/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.jdbc.resource;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.function.BiFunction;
import net.anwiba.commons.jdbc.resource.ResourceUtilities;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.utilities.string.StringUtilities;

public abstract class AbstractStatementString {
    static final ILogger logger = Logging.getLogger((String)AbstractStatementString.class.getName());
    private static final String EXTENSION = "sql";
    private static final int MOD_EXPECTED = 9;
    private static final int MOD_MASK = 25;
    private static final Object ASSIGNED = new Object();

    public static void initialize(final Class<?> clazz, final BiFunction<Class, String, InputStream> helper) {
        if (System.getSecurityManager() == null) {
            AbstractStatementString.load(clazz, helper);
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                AbstractStatementString.load(clazz, helper);
                return null;
            }
        });
    }

    public static String bind(String statement, Object ... bindings) {
        return AbstractStatementString.bind(Locale.getDefault(), statement, bindings);
    }

    public static String bind(Locale local, String statement, Object ... bindings) {
        if (statement == null) {
            return "No statement available.";
        }
        if (bindings.length == 0) {
            return statement;
        }
        return new MessageFormat(AbstractStatementString.doubleQuots(statement.toCharArray()), local).format(bindings);
    }

    private static String doubleQuots(char[] characters) {
        StringBuilder builder = new StringBuilder();
        for (char character : characters) {
            if (character == '\'') {
                builder.append(character);
            }
            builder.append(character);
        }
        return builder.toString();
    }

    private static Map<String, String> buildVariants(String classRoot, Field[] fieldArray) {
        String pathRoot = classRoot.replace('.', '/');
        HashMap<String, String> resources = new HashMap<String, String>();
        for (Field field : fieldArray) {
            resources.put(field.getName(), pathRoot + "/" + field.getName() + ".sql");
        }
        return resources;
    }

    private static void computeMissingStatement(String bundleName, Map<Object, Object> fieldMap, Field[] fieldArray, boolean isAccessible) {
        for (Field field : fieldArray) {
            if ((field.getModifiers() & 0x19) != 9 || fieldMap.get(field.getName()) == ASSIGNED) continue;
            try {
                String value = "missing statement: " + field.getName() + " in: " + bundleName;
                logger.log(ILevel.WARNING, value);
                if (!isAccessible) {
                    field.setAccessible(true);
                }
                field.set(null, value);
            }
            catch (Exception e) {
                logger.log(ILevel.FATAL, "Error setting the missing statement value for: " + field.getName(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void load(Class<?> clazz, BiFunction<Class, String, InputStream> helper) {
        Field[] fieldArray = clazz.getDeclaredFields();
        ClassLoader loader = clazz.getClassLoader();
        boolean isAccessible = (clazz.getModifiers() & 1) != 0;
        int len = fieldArray.length;
        HashMap<Object, Object> fields = new HashMap<Object, Object>(len * 2);
        for (int i = 0; i < len; ++i) {
            fields.put(fieldArray[i].getName(), fieldArray[i]);
        }
        String bundleName = clazz.getPackage().getName();
        Map<String, String> resources = AbstractStatementString.buildVariants(bundleName, fieldArray);
        for (Field field : fieldArray) {
            String element = resources.get(field.getName());
            InputStream input = ResourceUtilities.getInputStream(helper, clazz, element);
            if (input == null) {
                logger.log(ILevel.SEVERE, "Error loading " + element);
                continue;
            }
            try {
                String value = AbstractStatementString.readInputStream(input);
                AbstractStatementString.setValue(fields, field, value, isAccessible);
            }
            catch (IOException e) {
                logger.log(ILevel.SEVERE, "Error loading " + element, (Throwable)e);
            }
            finally {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
        AbstractStatementString.computeMissingStatement(clazz.getName(), fields, fieldArray, isAccessible);
    }

    private static synchronized void setValue(Map<Object, Object> fields, Field field, String value, boolean isAccessible) {
        Object fieldObject = fields.put(field.getName(), ASSIGNED);
        if (fieldObject == ASSIGNED) {
            return;
        }
        if (fieldObject == null) {
            String msg = "unused statement: " + field.getName();
            logger.log(ILevel.WARNING, msg);
            return;
        }
        if ((field.getModifiers() & 0x19) != 9) {
            return;
        }
        try {
            if (!isAccessible) {
                field.setAccessible(true);
            }
            String fieldValue = value.replace("\r", "");
            if (field.getType().isArray()) {
                String[] array = AbstractStatementString.createArray(fieldValue);
                field.set(null, array);
                return;
            }
            field.set(null, fieldValue);
        }
        catch (Exception e) {
            logger.log(ILevel.SEVERE, "Exception setting field value.", (Throwable)e);
        }
    }

    private static String[] createArray(String fieldValue) {
        ArrayList<String> values = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(fieldValue, ";");
        while (tokenizer.hasMoreElements()) {
            String nextToken = tokenizer.nextToken().trim();
            if (StringUtilities.isNullOrEmpty((String)nextToken)) continue;
            values.add(nextToken);
        }
        return values.toArray(new String[values.size()]);
    }

    private static String readInputStream(InputStream inputStream) throws IOException {
        StringBuffer string = new StringBuffer();
        byte[] buffer = new byte[1024];
        int length = 0;
        while ((length = inputStream.read(buffer)) > -1) {
            string.append(new String(buffer, 0, length));
        }
        return string.toString().trim();
    }
}

