/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.jdbc.resource;

import java.io.File;
import java.io.Serializable;
import net.anwiba.commons.ensure.Ensure;
import net.anwiba.commons.lang.exception.CreationException;
import net.anwiba.commons.lang.functional.ResolvingException;
import net.anwiba.commons.utilities.string.IStringAppender;
import net.anwiba.commons.utilities.string.StringAppender;
import net.anwiba.commons.utilities.string.StringResolverBuilder;

public class JdbcFileSystemUrlStringResolver
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String PLACEHOLDER_PROTOCOL = "protocol";
    private static final String PLACEHOLDER_DATABASE = "database";
    private final String urlPattern;

    public JdbcFileSystemUrlStringResolver(String urlPattern) {
        this.urlPattern = urlPattern;
    }

    public String create(String protocol, File database) throws CreationException {
        Ensure.ensureArgumentNotNull((Object)database);
        StringAppender errorHandler = new StringAppender();
        try {
            String string = (String)new StringResolverBuilder().errorHandler((IStringAppender)errorHandler).add(PLACEHOLDER_PROTOCOL, protocol).add(PLACEHOLDER_DATABASE, database.getPath()).build().resolve((Object)this.urlPattern);
            return string;
        }
        catch (ResolvingException exception) {
            throw new CreationException(errorHandler.toString());
        }
        finally {
            if (!errorHandler.isEmpty()) {
                throw new CreationException(errorHandler.toString());
            }
        }
    }
}

