/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.jdbc.resource;

import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.BiFunction;

public class ResourceUtilities {
    public static InputStream getInputStream(BiFunction<Class, String, InputStream> helper, Class clazz, String resourceUrl) {
        return helper.apply(clazz, ResourceUtilities.toRelativePathIfNot(clazz, resourceUrl));
    }

    private static String toRelativePathIfNot(Class clazz, String resourceUrl) {
        Path packagePath;
        Path resourcePath = Paths.get(resourceUrl, new String[0]).normalize();
        if (resourcePath.startsWith(packagePath = Paths.get("", clazz.getPackage().getName().split("\\.")))) {
            return ResourceUtilities.toString(packagePath.relativize(resourcePath).normalize());
        }
        return resourceUrl.startsWith("/") ? resourceUrl.substring(1) : resourceUrl;
    }

    private static String toString(Path path) {
        Object string = null;
        for (Path item : path) {
            if (string == null) {
                string = item.toString();
                continue;
            }
            string = (String)string + "/" + item.toString();
        }
        return string;
    }
}

