/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.jdbc.result;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.util.NoSuchElementException;
import net.anwiba.commons.jdbc.result.IResult;
import net.anwiba.commons.jdbc.result.IResults;
import net.anwiba.commons.jdbc.result.ResultSetToResultAdapter;

public class ResultSetToResultsAdapter
implements IResults {
    private final ResultSet resultSet;
    private IResult result = null;

    public ResultSetToResultsAdapter(ResultSet resultSet) {
        this.resultSet = resultSet;
    }

    public boolean hasNext() throws SQLException {
        if (this.result != null) {
            return true;
        }
        try {
            this.result = this.resultSet.next() ? new ResultSetToResultAdapter(this.resultSet) : null;
            return this.result != null;
        }
        catch (SQLRecoverableException exception) {
            if (exception.getMessage().contains("interrupted") || exception.getMessage().contains("Closed Connection")) {
                return false;
            }
            throw exception;
        }
    }

    public IResult next() throws SQLException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            IResult iResult = this.result;
            return iResult;
        }
        finally {
            this.result = null;
        }
    }

    public void close() throws SQLException {
        try {
            this.resultSet.close();
        }
        catch (SQLRecoverableException exception) {
            if (exception.getMessage().contains("interrupted") || exception.getMessage().contains("Closed Connection")) {
                return;
            }
            throw exception;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.resultSet.isClosed();
    }
}

