/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.jdbc.type;

import net.anwiba.commons.jdbc.type.IDatabaseTypeVisitor;

public enum DatabaseType {
    BIT(-7){

        @Override
        public <T, E extends Exception> T accept(IDatabaseTypeVisitor<T, E> visitor) throws E {
            return visitor.visitUnsupportedType();
        }
    }
    ,
    TINYINT(-6){

        @Override
        public <T, E extends Exception> T accept(IDatabaseTypeVisitor<T, E> visitor) throws E {
            return visitor.visitShort();
        }
    }
    ,
    SMALLINT(5){

        @Override
        public <T, E extends Exception> T accept(IDatabaseTypeVisitor<T, E> visitor) throws E {
            return visitor.visitShort();
        }
    }
    ,
    INTEGER(4){

        @Override
        public <T, E extends Exception> T accept(IDatabaseTypeVisitor<T, E> visitor) throws E {
            return visitor.visitInteger();
        }
    }
    ,
    BIGINT(-5){

        @Override
        public <T, E extends Exception> T accept(IDatabaseTypeVisitor<T, E> visitor) throws E {
            return visitor.visitLong();
        }
    }
    ,
    FLOAT(6){

        @Override
        public <T, E extends Exception> T accept(IDatabaseTypeVisitor<T, E> visitor) throws E {
            return visitor.visitFloat();
        }
    }
    ,
    REAL(7){

        @Override
        public <T, E extends Exception> T accept(IDatabaseTypeVisitor<T, E> visitor) throws E {
            return visitor.visitDouble();
        }
    }
    ,
    DOUBLE(8){

        @Override
        public <T, E extends Exception> T accept(IDatabaseTypeVisitor<T, E> visitor) throws E {
            return visitor.visitDouble();
        }
    }
    ,
    NUMERIC(2){

        @Override
        public <T, E extends Exception> T accept(IDatabaseTypeVisitor<T, E> visitor) throws E {
            return visitor.visitNumeric();
        }
    }
    ,
    DECIMAL(3){

        @Override
        public <T, E extends Exception> T accept(IDatabaseTypeVisitor<T, E> visitor) throws E {
            return visitor.visitDouble();
        }
    }
    ,
    CHAR(1){

        @Override
        public <T, E extends Exception> T accept(IDatabaseTypeVisitor<T, E> visitor) throws E {
            return visitor.visitChar();
        }
    }
    ,
    VARCHAR(12){

        @Override
        public <T, E extends Exception> T accept(IDatabaseTypeVisitor<T, E> visitor) throws E {
            return visitor.visitVarchar();
        }
    }
    ,
    LONGVARCHAR(-16){

        @Override
        public <T, E extends Exception> T accept(IDatabaseTypeVisitor<T, E> visitor) throws E {
            return visitor.visitUnsupportedType();
        }
    }
    ,
    DATE(91){

        @Override
        public <T, E extends Exception> T accept(IDatabaseTypeVisitor<T, E> visitor) throws E {
            return visitor.visitDate();
        }
    }
    ,
    TIME(92){

        @Override
        public <T, E extends Exception> T accept(IDatabaseTypeVisitor<T, E> visitor) throws E {
            return visitor.visitTime();
        }
    }
    ,
    TIMESTAMP(93){

        @Override
        public <T, E extends Exception> T accept(IDatabaseTypeVisitor<T, E> visitor) throws E {
            return visitor.visitTimeStamp();
        }
    }
    ,
    BINARY(-2){

        @Override
        public <T, E extends Exception> T accept(IDatabaseTypeVisitor<T, E> visitor) throws E {
            return visitor.visitUnsupportedType();
        }
    }
    ,
    VARBINARY(-3){

        @Override
        public <T, E extends Exception> T accept(IDatabaseTypeVisitor<T, E> visitor) throws E {
            return visitor.visitUnsupportedType();
        }
    }
    ,
    LONGVARBINARY(-4){

        @Override
        public <T, E extends Exception> T accept(IDatabaseTypeVisitor<T, E> visitor) throws E {
            return visitor.visitUnsupportedType();
        }
    }
    ,
    NULL(0){

        @Override
        public <T, E extends Exception> T accept(IDatabaseTypeVisitor<T, E> visitor) throws E {
            return visitor.visitUnsupportedType();
        }
    }
    ,
    OTHER(1111){

        @Override
        public <T, E extends Exception> T accept(IDatabaseTypeVisitor<T, E> visitor) throws E {
            return visitor.visitOther();
        }
    }
    ,
    JAVA_OBJECT(1111){

        @Override
        public <T, E extends Exception> T accept(IDatabaseTypeVisitor<T, E> visitor) throws E {
            return visitor.visitUnsupportedType();
        }
    }
    ,
    DISTINCT(2001){

        @Override
        public <T, E extends Exception> T accept(IDatabaseTypeVisitor<T, E> visitor) throws E {
            return visitor.visitUnsupportedType();
        }
    }
    ,
    STRUCT(2002){

        @Override
        public <T, E extends Exception> T accept(IDatabaseTypeVisitor<T, E> visitor) throws E {
            return visitor.visitStrukt();
        }
    }
    ,
    ARRAY(2003){

        @Override
        public <T, E extends Exception> T accept(IDatabaseTypeVisitor<T, E> visitor) throws E {
            return visitor.visitUnsupportedType();
        }
    }
    ,
    BLOB(2004){

        @Override
        public <T, E extends Exception> T accept(IDatabaseTypeVisitor<T, E> visitor) throws E {
            return visitor.visitUnsupportedType();
        }
    }
    ,
    CLOB(2005){

        @Override
        public <T, E extends Exception> T accept(IDatabaseTypeVisitor<T, E> visitor) throws E {
            return visitor.visitUnsupportedType();
        }
    }
    ,
    REF(2006){

        @Override
        public <T, E extends Exception> T accept(IDatabaseTypeVisitor<T, E> visitor) throws E {
            return visitor.visitUnsupportedType();
        }
    }
    ,
    DATALINK(70){

        @Override
        public <T, E extends Exception> T accept(IDatabaseTypeVisitor<T, E> visitor) throws E {
            return visitor.visitUnsupportedType();
        }
    }
    ,
    BOOLEAN(16){

        @Override
        public <T, E extends Exception> T accept(IDatabaseTypeVisitor<T, E> visitor) throws E {
            return visitor.visitBoolean();
        }
    }
    ,
    ROWID(-8){

        @Override
        public <T, E extends Exception> T accept(IDatabaseTypeVisitor<T, E> visitor) throws E {
            return visitor.visitUnsupportedType();
        }
    }
    ,
    NCHAR(-15){

        @Override
        public <T, E extends Exception> T accept(IDatabaseTypeVisitor<T, E> visitor) throws E {
            return visitor.visitUnsupportedType();
        }
    }
    ,
    NVARCHAR(-9){

        @Override
        public <T, E extends Exception> T accept(IDatabaseTypeVisitor<T, E> visitor) throws E {
            return visitor.visitUnsupportedType();
        }
    }
    ,
    LONGNVARCHAR(-16){

        @Override
        public <T, E extends Exception> T accept(IDatabaseTypeVisitor<T, E> visitor) throws E {
            return visitor.visitUnsupportedType();
        }
    }
    ,
    NCLOB(2011){

        @Override
        public <T, E extends Exception> T accept(IDatabaseTypeVisitor<T, E> visitor) throws E {
            return visitor.visitUnsupportedType();
        }
    }
    ,
    SQLXML(2009){

        @Override
        public <T, E extends Exception> T accept(IDatabaseTypeVisitor<T, E> visitor) throws E {
            return visitor.visitUnsupportedType();
        }
    }
    ,
    UNKNOWN(Integer.MAX_VALUE){

        @Override
        public <T, E extends Exception> T accept(IDatabaseTypeVisitor<T, E> visitor) throws E {
            return visitor.visitUnknown();
        }
    };

    private final int code;

    private DatabaseType(int code) {
        this.code = code;
    }

    public static DatabaseType getByTypeId(int code) {
        for (DatabaseType databaseType : DatabaseType.values()) {
            if (databaseType.code != code) continue;
            return databaseType;
        }
        return UNKNOWN;
    }

    public int getCode() {
        return this.code;
    }

    public static DatabaseType getByName(String name) {
        for (DatabaseType databaseType : DatabaseType.values()) {
            if (!databaseType.name().equals(name.trim().toUpperCase())) continue;
            return databaseType;
        }
        return UNKNOWN;
    }

    public abstract <T, E extends Exception> T accept(IDatabaseTypeVisitor<T, E> var1) throws E;
}

