/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.jdbc;

import java.sql.SQLException;
import net.anwiba.commons.lang.exception.IThrowableToStringConverter;
import net.anwiba.commons.utilities.string.StringUtilities;

public class SqlExceptionToStringConverter
implements IThrowableToStringConverter {
    public boolean isApplicable(Throwable throwable) {
        return throwable instanceof SQLException;
    }

    public String toString(Throwable throwable) {
        SQLException sqlException = (SQLException)throwable;
        String reason = sqlException.getMessage();
        String state = sqlException.getSQLState();
        int errorCode = sqlException.getErrorCode();
        StringBuilder builder = new StringBuilder();
        builder.append(reason);
        if (errorCode != 0) {
            builder.append("; code=");
            builder.append(errorCode);
        }
        if (!StringUtilities.isNullOrEmpty((String)state)) {
            builder.append("; state=");
            builder.append(state);
        }
        return builder.toString();
    }
}

