/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.jdbc.metadata;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.anwiba.commons.ensure.Ensure;
import net.anwiba.commons.jdbc.constraint.Constraint;
import net.anwiba.commons.jdbc.metadata.ColumnResultSetMetadata;
import net.anwiba.commons.jdbc.metadata.IColumnMetaData;
import net.anwiba.commons.jdbc.metadata.ITableMetaData;
import net.anwiba.commons.lang.exception.UnreachableCodeReachedException;

public class TableResultSetMetaData
implements ITableMetaData {
    private final ResultSetMetaData resultSetMetaData;
    private final Map<String, Constraint> constraints = new HashMap<String, Constraint>();

    public TableResultSetMetaData(ResultSetMetaData resultSetMetaData) {
        Ensure.ensureArgumentNotNull((Object)resultSetMetaData);
        this.resultSetMetaData = resultSetMetaData;
    }

    @Override
    public IColumnMetaData getColumnMetaData(int index) {
        return new ColumnResultSetMetadata(this.resultSetMetaData, index + 1);
    }

    @Override
    public int getColumnCount() {
        try {
            return this.resultSetMetaData.getColumnCount();
        }
        catch (SQLException exception) {
            throw new UnreachableCodeReachedException();
        }
    }

    @Override
    public Map<String, Constraint> getConstraints() {
        return this.constraints;
    }

    @Override
    public Iterator<IColumnMetaData> iterator() {
        return null;
    }
}

