/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.jdbc.software;

import java.sql.Driver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.anwiba.commons.jdbc.DatabaseUtilities;
import net.anwiba.commons.jdbc.software.IDatabaseSoftware;
import net.anwiba.commons.jdbc.software.IJdbcPattern;
import net.anwiba.commons.jdbc.software.JdbcPattern;

public enum ServiceDatabaseSoftware implements IDatabaseSoftware
{
    ORACLE("oracle.jdbc.OracleDriver", "jdbc:oracle:thin", 1521, "sid", (Map)ServiceDatabaseSoftware.createJdbcUrlPatterns(Arrays.asList("sid", "service"), Arrays.asList("${protocol}:@${host}:${port}:${database}", "${protocol}:@//${host}:${port}/${database}")), "oracle.spatial.geometry.JGeometry"){}
    ,
    POSTGRES("org.postgresql.Driver", "jdbc:postgresql", 5432, "default", (Map)ServiceDatabaseSoftware.createJdbcUrlPatterns(Arrays.asList("default"), Arrays.asList("${protocol}://${host}:${port}/${database}")), "net.postgis.jdbc.geometry.Geometry"){}
    ,
    H2("org.h2.Driver", "jdbc:h2", 0, "tcp", (Map)ServiceDatabaseSoftware.createJdbcUrlPatterns(Arrays.asList("tcp", "ssl"), Arrays.asList("${protocol}:tcp://${host}:${port}/${database}", "${protocol}:ssl://${host}:${port}/${database}")), "org.locationtech.jts.geom.Geometry"){}
    ,
    HANA("com.sap.db.jdbc.Driver", "jdbc:sap", 30015, "default", (Map)ServiceDatabaseSoftware.createJdbcUrlPatterns(Arrays.asList("default"), Arrays.asList("${protocol}://${host}:${port}")), "java.lang.Object"){};

    private transient Driver driver;
    private final Map<String, IJdbcPattern> jdbcUrlPatterns = new HashMap<String, IJdbcPattern>();
    private final String protocol;
    private final int port;
    private final String geometryClassName;
    private final String driverName;
    private final String defaultJdbcUrlPatternName;

    static Map<String, IJdbcPattern> createJdbcUrlPatterns(List<String> names, List<String> patterns) {
        HashMap<String, IJdbcPattern> jdbcUrlPatterns = new HashMap<String, IJdbcPattern>();
        for (int i = 0; i < names.size(); ++i) {
            jdbcUrlPatterns.put(names.get(i), new JdbcPattern(names.get(i), patterns.get(i)));
        }
        return jdbcUrlPatterns;
    }

    private ServiceDatabaseSoftware(String driverName, String protocol, int port, String defaultJdbcUrlPatternName, Map<String, IJdbcPattern> jdbcUrlPatterns, String geometryClassName) {
        this.driverName = driverName;
        this.defaultJdbcUrlPatternName = defaultJdbcUrlPatternName;
        this.jdbcUrlPatterns.putAll(jdbcUrlPatterns);
        this.driver = DatabaseUtilities.loadDriver(driverName);
        this.protocol = protocol;
        this.port = port;
        this.geometryClassName = geometryClassName;
    }

    @Override
    public Driver getDriver() {
        if (this.driver == null) {
            Driver _driver;
            this.driver = _driver = DatabaseUtilities.loadDriver(this.driverName);
        }
        return this.driver;
    }

    @Override
    public String getDriverName() {
        return this.driverName;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public boolean isApplicable() {
        return this.getDriver() != null;
    }

    @Override
    public boolean isGisSupportApplicable() {
        try {
            Class.forName(this.geometryClassName);
            return true;
        }
        catch (ClassNotFoundException exception) {
            return false;
        }
    }

    public static ServiceDatabaseSoftware getByUrl(String url) {
        ServiceDatabaseSoftware[] values;
        if (url == null) {
            return null;
        }
        for (ServiceDatabaseSoftware serviceDatabaseSoftware : values = ServiceDatabaseSoftware.values()) {
            if (!url.toLowerCase().startsWith(serviceDatabaseSoftware.getProtocol())) continue;
            return serviceDatabaseSoftware;
        }
        return null;
    }

    @Override
    public String getDefaultJdbcUrlPatternName() {
        return this.defaultJdbcUrlPatternName;
    }

    @Override
    public IJdbcPattern getJdbcUrlPattern(String name) {
        return this.jdbcUrlPatterns.get(name);
    }

    @Override
    public List<IJdbcPattern> getJdbcUrlPatterns() {
        return new ArrayList<IJdbcPattern>(this.jdbcUrlPatterns.values());
    }
}

