//Copyright (c) 2016 by Andreas W. Bartels
package net.anwiba.commons.json.schema.v1_0;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;

@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "type")
@JsonSubTypes({
    @JsonSubTypes.Type(value = BooleanProperty.class, name = "boolean"),
    @JsonSubTypes.Type(value = IntegerProperty.class, name = "integer"),
    @JsonSubTypes.Type(value = NumberProperty.class, name = "number"),
    @JsonSubTypes.Type(value = ObjectProperty.class, name = "object"),
    @JsonSubTypes.Type(value = StringProperty.class, name = "string")
})
@JsonIgnoreProperties(ignoreUnknown = true)
public class Property {

    private final String type = "property";
    private String name = null;
    private String title = null;
    private String description = null;

    @JsonIgnore
    public void setType(final String type) {
    }

    @JsonIgnore
    public String getType() {
        return this.type;
    }

    @JsonProperty("name")
    public void setName(final String name) {
        this.name = name;
    }

    @JsonProperty("name")
    public String getName() {
        return this.name;
    }

    @JsonProperty("title")
    public void setTitle(final String title) {
        this.title = title;
    }

    @JsonProperty("title")
    public String getTitle() {
        return this.title;
    }

    @JsonProperty("description")
    public void setDescription(final String description) {
        this.description = description;
    }

    @JsonProperty("description")
    public String getDescription() {
        return this.description;
    }

}
