/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SequenceWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.util.NoSuchElementException;
import net.anwiba.commons.json.JsonObjectMarshaller;
import net.anwiba.commons.json.JsonObjectUnmarshaller;
import net.anwiba.commons.lang.functional.IClosableIterator;
import net.anwiba.commons.lang.functional.ICloseableConsumer;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.lang.functional.IProcedure;

public class JsonObjectUtilities {
    public static <T> T unmarshall(Class<T> clazz, String string) throws IOException {
        JsonObjectUnmarshaller<T> unmarshaller = new JsonObjectUnmarshaller<T>(clazz);
        return (T)unmarshaller.unmarshal(string);
    }

    public static <T> String marshall(T bean) {
        try {
            JsonObjectMarshaller marshaller = new JsonObjectMarshaller(bean.getClass(), false);
            StringWriter outputStream = new StringWriter();
            marshaller.marshall(outputStream, bean);
            return outputStream.toString();
        }
        catch (IOException exception) {
            throw new RuntimeException("Unreachable code reached", exception);
        }
    }

    public static <I, O> IClosableIterator<O, IOException> iterator(final InputStream inputStream, final Class<I> clazz, final IProcedure<JsonParser, IOException> initializer, final IConverter<I, O, IOException> converter, final IProcedure<JsonParser, IOException> closer) {
        return new IClosableIterator<O, IOException>(){
            private boolean isClosed = false;
            private O value;
            private JsonParser parser;
            private MappingIterator<I> iterator;

            public void close() throws IOException {
                this.check();
                this.isClosed = true;
                IOException exception = JsonObjectUtilities.close(() -> closer.execute((Object)this.parser), null);
                exception = JsonObjectUtilities.close(this.iterator, exception);
                exception = JsonObjectUtilities.close((Closeable)this.parser, exception);
                if (exception != null) {
                    throw exception;
                }
            }

            public boolean hasNext() throws IOException {
                this.check();
                if (this.value != null) {
                    return true;
                }
                if (this.iterator == null) {
                    this.initialize();
                }
                if (!this.iterator.hasNext()) {
                    return false;
                }
                this.value = converter.convert(this.iterator.next());
                return true;
            }

            public O next() throws IOException {
                this.check();
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                try {
                    Object o = this.value;
                    return o;
                }
                finally {
                    this.value = null;
                }
            }

            private void check() throws IOException {
                if (this.isClosed) {
                    throw new IOException("initializer is closed");
                }
            }

            private void initialize() throws IOException {
                this.parser = new JsonFactory().createParser((Reader)new InputStreamReader(inputStream, "utf-8"));
                initializer.execute((Object)this.parser);
                this.iterator = new ObjectMapper().readerFor(clazz).readValues(this.parser);
            }
        };
    }

    public static <I, O> ICloseableConsumer<I, Boolean, IOException> consumer(final OutputStream outputStream, final Class<O> clazz, final IProcedure<JsonGenerator, IOException> initializer, final IConverter<I, O, IOException> converter, final IProcedure<JsonGenerator, IOException> closer) {
        return new ICloseableConsumer<I, Boolean, IOException>(){
            private boolean isClosed = false;
            private JsonGenerator generator;
            private SequenceWriter writer;

            public void close() throws IOException {
                this.check();
                this.isClosed = true;
                IOException exception = JsonObjectUtilities.close(() -> closer.execute((Object)this.generator), null);
                exception = JsonObjectUtilities.close((Closeable)this.writer, exception);
                exception = JsonObjectUtilities.close((Closeable)this.generator, exception);
                if (exception != null) {
                    throw exception;
                }
            }

            public Boolean consume(I object) throws IOException {
                Object value;
                this.check();
                if (this.generator == null) {
                    this.initialize();
                }
                if ((value = converter.convert(object)) == null) {
                    return false;
                }
                this.writer.write(value);
                return true;
            }

            private void check() throws IOException {
                if (this.isClosed) {
                    throw new IOException("consumer is closed");
                }
            }

            private void initialize() throws IOException {
                this.generator = new JsonFactory().createGenerator(outputStream).configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
                initializer.execute((Object)this.generator);
                this.writer = new ObjectMapper().writerFor(clazz).with(SerializationFeature.FLUSH_AFTER_WRITE_VALUE).writeValuesAsArray(this.generator);
            }
        };
    }

    private static IOException close(Closeable closeable, IOException exception) {
        if (closeable == null) {
            return exception;
        }
        try {
            closeable.close();
            return exception;
        }
        catch (IOException ioException) {
            if (exception == null) {
                return ioException;
            }
            exception.addSuppressed(ioException);
            return exception;
        }
    }
}

