/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.anwiba.commons.json.IJsonObjectMapperExceptionFactory;
import net.anwiba.commons.resource.utilities.IoUtilities;

public abstract class AbstractJsonObjectsUnmarshaller<T, R, E extends IOException> {
    private final ObjectMapper mapper = new ObjectMapper();
    private final Class<R> errorResponseClass;
    private final IJsonObjectMapperExceptionFactory<R, E> exceptionFactory;
    private final Class<T> clazz;
    private final Map<Class, Object> injectionValues = new HashMap<Class, Object>();

    public AbstractJsonObjectsUnmarshaller(Class<T> clazz, Class<R> errorResponseClass, Map<Class, Object> injectionValues, IJsonObjectMapperExceptionFactory<R, E> exceptionFactory) {
        this.clazz = clazz;
        this.errorResponseClass = errorResponseClass;
        this.injectionValues.putAll(injectionValues);
        this.exceptionFactory = exceptionFactory;
        this.mapper.getFactory().configure(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS, true);
    }

    public List<T> unmarshal(InputStream inputStream) throws IOException, E {
        return this.unmarshal(IoUtilities.toString((InputStream)inputStream, (String)"UTF-8"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<T> unmarshal(String body) throws IOException, E {
        T result = this.validate(body);
        if (result != null) {
            return Arrays.asList(result);
        }
        try {
            InjectableValues.Std injectableValues = new InjectableValues.Std();
            for (Class key : this.injectionValues.keySet()) {
                injectableValues.addValue(key, this.injectionValues.get(key));
            }
            JsonFactory f = new JsonFactory();
            Object object = null;
            Object var6_9 = null;
            try {
                List list;
                JsonParser parser = f.createParser(body);
                try {
                    ObjectReader reader = this.mapper.readerFor(this.clazz).with((InjectableValues)injectableValues);
                    JsonToken token = parser.nextToken();
                    if (token != JsonToken.START_ARRAY) {
                        list = (List)reader.readValue(parser);
                        return list;
                    }
                    ArrayList<Object> results = new ArrayList<Object>();
                    while (parser.nextToken() == JsonToken.START_OBJECT) {
                        Object value = reader.readValue(parser);
                        results.add(value);
                    }
                    return results;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (parser == null) return list;
                    parser.close();
                }
            }
            catch (Throwable throwable) {
                if (object == null) {
                    object = throwable;
                    throw object;
                }
                if (object == throwable) throw object;
                ((Throwable)object).addSuppressed(throwable);
                throw object;
            }
        }
        catch (JsonParseException exception) {
            throw AbstractJsonObjectsUnmarshaller.createIOException(body, (Exception)((Object)exception));
        }
        catch (JsonMappingException exception) {
            throw AbstractJsonObjectsUnmarshaller.createIOException(body, (Exception)((Object)exception));
        }
    }

    private <X> X check(String body, Class<X> type) throws IOException, JsonParseException, JsonMappingException, JsonProcessingException {
        InjectableValues.Std injectableValues = new InjectableValues.Std();
        for (Class key : this.injectionValues.keySet()) {
            injectableValues.addValue(key, this.injectionValues.get(key));
        }
        return (X)this.mapper.readerFor(type).with((InjectableValues)injectableValues).readValue(body);
    }

    private T validate(String body) throws IOException, E {
        if (Void.class.equals(this.errorResponseClass)) {
            return null;
        }
        try {
            R response = this.check(body, this.errorResponseClass);
            if (this.clazz.isInstance(response)) {
                return (T)response;
            }
            throw (IOException)this.exceptionFactory.create(response);
        }
        catch (JsonParseException jsonParseException) {
            return null;
        }
        catch (JsonMappingException jsonMappingException) {
            return null;
        }
    }

    private static IOException createIOException(String content, Exception exception) {
        return new IOException(MessageFormat.format("Error during mapping json resource, coudn''t map the content:\n {0}", content), exception);
    }
}

