/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.json;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.anwiba.commons.json.AbstractJsonUnmarshaller;
import net.anwiba.commons.json.IJsonObjectMarshallingExceptionFactory;

public abstract class AbstractJsonObjectUnmarshaller<T, R, E extends IOException>
extends AbstractJsonUnmarshaller<T, T, R, IOException> {
    private final ObjectMapper mapper = new ObjectMapper();
    private final IJsonObjectMarshallingExceptionFactory<R, E> exceptionFactory;
    private final Class<T> clazz;
    private final Map<String, Object> injectionValues = new HashMap<String, Object>();

    public AbstractJsonObjectUnmarshaller(Class<T> clazz, Class<R> errorResponseClass, Map<String, Object> injectionValues, IJsonObjectMarshallingExceptionFactory<R, E> exceptionFactory) {
        super(clazz, errorResponseClass, injectionValues);
        this.clazz = clazz;
        this.injectionValues.putAll(injectionValues);
        this.exceptionFactory = exceptionFactory;
        this.mapper.getFactory().configure(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS, true);
    }

    @Override
    protected T _unmarshal(InputStream stream) throws IOException, E {
        stream.mark(Integer.MAX_VALUE);
        Object result = this.validate(stream);
        if (result != null) {
            return result;
        }
        stream.reset();
        stream.mark(Integer.MAX_VALUE);
        try {
            return this.read(stream, this.clazz);
        }
        catch (JsonParseException | JsonMappingException exception) {
            stream.reset();
            throw this.createIOException(stream, (Exception)exception);
        }
    }

    private <X> X read(InputStream stream, Class<X> type) throws IOException, JsonParseException, JsonMappingException, JsonProcessingException {
        InjectableValues.Std injectableValues = new InjectableValues.Std();
        for (String key : this.injectionValues.keySet()) {
            injectableValues.addValue(key, this.injectionValues.get(key));
        }
        return (X)this.mapper.readerFor(type).with((InjectableValues)injectableValues).readValue(stream);
    }

    @Override
    protected IOException createException(R response) {
        return (IOException)this.exceptionFactory.create(response);
    }
}

