/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.anwiba.commons.json.AbstractJsonUnmarshaller;
import net.anwiba.commons.json.IJsonObjectMarshallingExceptionFactory;

public abstract class AbstractJsonObjectsUnmarshaller<T, R, E extends IOException>
extends AbstractJsonUnmarshaller<T, List<T>, R, IOException> {
    private final ObjectMapper mapper = new ObjectMapper();
    private final IJsonObjectMarshallingExceptionFactory<R, E> exceptionFactory;
    private final Class<T> clazz;
    private final Map<String, Object> injectionValues = new HashMap<String, Object>();

    public AbstractJsonObjectsUnmarshaller(Class<T> clazz, Class<R> errorResponseClass, Map<String, Object> injectionValues, IJsonObjectMarshallingExceptionFactory<R, E> exceptionFactory) {
        super(clazz, errorResponseClass, injectionValues);
        this.clazz = clazz;
        this.injectionValues.putAll(injectionValues);
        this.exceptionFactory = exceptionFactory;
        this.mapper.getFactory().configure(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected List<T> _unmarshal(InputStream stream) throws IOException, E {
        stream.mark(Integer.MAX_VALUE);
        List result = (List)this.validate(stream);
        if (result != null) {
            return result;
        }
        stream.reset();
        stream.mark(Integer.MAX_VALUE);
        try {
            InjectableValues.Std injectableValues = new InjectableValues.Std();
            for (String key : this.injectionValues.keySet()) {
                injectableValues.addValue(key, this.injectionValues.get(key));
            }
            JsonFactory f = new JsonFactory();
            Object object = null;
            Object var6_8 = null;
            try {
                List<Object> list;
                JsonParser parser = f.createParser(stream);
                try {
                    ObjectReader reader = this.mapper.readerFor(this.clazz).with((InjectableValues)injectableValues);
                    JsonToken token = parser.nextToken();
                    if (token != JsonToken.START_ARRAY) {
                        Object value = reader.readValue(parser);
                        list = Arrays.asList(value);
                        return list;
                    }
                    ArrayList<Object> results = new ArrayList<Object>();
                    while (parser.nextToken() == JsonToken.START_OBJECT) {
                        Object value = reader.readValue(parser);
                        results.add(value);
                    }
                    return results;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (parser == null) return list;
                    parser.close();
                }
            }
            catch (Throwable throwable) {
                if (object == null) {
                    object = throwable;
                    throw object;
                }
                if (object == throwable) throw object;
                ((Throwable)object).addSuppressed(throwable);
                throw object;
            }
        }
        catch (JsonParseException | JsonMappingException exception) {
            stream.reset();
            throw this.createIOException(stream, (Exception)exception);
        }
    }

    @Override
    protected IOException createException(R response) {
        return (IOException)this.exceptionFactory.create(response);
    }
}

