//Copyright (c) 2012 by Andreas W. Bartels
package net.anwiba.commons.json.schema.v1_0;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public class ObjectProperty
    extends net.anwiba.commons.json.schema.v1_0.Property
{

    private final String type = "object";
    private String format = null;
    private net.anwiba.commons.json.schema.v1_0.Property required = null;
    private final Map<String, net.anwiba.commons.json.schema.v1_0.Property> properties = new LinkedHashMap<String, net.anwiba.commons.json.schema.v1_0.Property>();

    @JsonIgnore
    public void setType(final String type) {
    }

    @JsonIgnore
    public String getType() {
        return this.type;
    }

    @JsonProperty("format")
    public void setFormat(final String format) {
        this.format = format;
    }

    @JsonProperty("format")
    public String getFormat() {
        return this.format;
    }

    @JsonProperty("required")
    public void setRequired(final net.anwiba.commons.json.schema.v1_0.Property required) {
        this.required = required;
    }

    @JsonProperty("required")
    public net.anwiba.commons.json.schema.v1_0.Property getRequired() {
        return this.required;
    }

    public void setProperties(final String name, final net.anwiba.commons.json.schema.v1_0.Property value) {
        Objects.requireNonNull(name);
        this.properties.put(name, value);
    }

    @JsonProperty("properties")
    public void setProperties(final Map<String, net.anwiba.commons.json.schema.v1_0.Property> properties) {
        if (properties == null) {
            this.properties.clear();
            return ;
        }
        this.properties.clear();
        this.properties.putAll(properties);
    }

    public net.anwiba.commons.json.schema.v1_0.Property getProperties(final String name) {
        if (name == null) {
            return null;
        }
        return this.properties.get(name);
    }

    @JsonProperty("properties")
    public Map<String, net.anwiba.commons.json.schema.v1_0.Property> getProperties() {
        if (this.properties.isEmpty()) {
            return null;
        }
        return this.properties;
    }

}
