/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.json;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.anwiba.commons.lang.io.NoneClosingInputStream;

public abstract class AbstractJsonUnmarshaller<T, O, R, E extends IOException> {
    private final ObjectMapper mapper = new ObjectMapper();
    private final Class<R> errorResponseClass;
    private final Class<T> clazz;
    private final Map<String, Object> injectionValues = new HashMap<String, Object>();

    public AbstractJsonUnmarshaller(Class<T> clazz, Class<R> errorResponseClass, Map<String, Object> injectionValues, Collection<DeserializationProblemHandler> problemHandlers) {
        this.clazz = clazz;
        this.errorResponseClass = errorResponseClass;
        this.injectionValues.putAll(injectionValues);
        this.mapper.findAndRegisterModules();
        this.mapper.getFactory().configure(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS, true);
        problemHandlers.forEach(h -> this.mapper.addHandler(h));
    }

    public final O unmarshal(String body) throws IOException, E {
        return this.unmarshal(new ByteArrayInputStream(body.getBytes(Charset.forName("UTF-8"))));
    }

    public final O unmarshal(InputStream inputStream) throws IOException, E {
        return this._unmarshal((InputStream)new NoneClosingInputStream((InputStream)(inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream))));
    }

    protected abstract O _unmarshal(InputStream var1) throws IOException, E;

    private String toString(InputStream inputStream, String contentEncoding) throws IOException {
        int numChars;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        while ((numChars = inputStream.read(buffer)) > 0) {
            out.write(buffer, 0, numChars);
        }
        String string = out.toString(contentEncoding);
        return string.length() > 8200 ? string.substring(0, 8200) + "..." : string;
    }

    private <X> X check(InputStream stream, Class<X> type) throws IOException, JsonParseException, JsonMappingException, JsonProcessingException {
        InjectableValues.Std injectableValues = new InjectableValues.Std();
        for (String key : this.injectionValues.keySet()) {
            injectableValues.addValue(key, this.injectionValues.get(key));
        }
        return (X)this.mapper.readerFor(type).with((InjectableValues)injectableValues).readValue(stream);
    }

    protected T validate(InputStream stream) throws IOException, E {
        if (Void.class.equals(this.errorResponseClass)) {
            return null;
        }
        try {
            R response = this.check(stream, this.errorResponseClass);
            if (this.clazz.isInstance(response)) {
                return (T)response;
            }
            throw this.createException(response);
        }
        catch (JsonParseException e) {
            return null;
        }
        catch (JsonMappingException e) {
            return null;
        }
    }

    protected abstract E createException(R var1);

    protected IOException createIOException(InputStream content, Exception exception) {
        try {
            return new IOException(MessageFormat.format("Error during mapping json resource, coudn''t map the content:\n {0}", this.toString(content, "UTF-8")), exception);
        }
        catch (IOException exception1) {
            return new IOException("Error during mapping json resource, coudn''t map the content", exception);
        }
    }
}

