/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class JsonObjectMarshaller<T> {
    private final ObjectWriter writer;

    public JsonObjectMarshaller(Class<T> clazz, boolean isPrittyPrintEnabled) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.findAndRegisterModules();
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        if (isPrittyPrintEnabled) {
            this.writer = mapper.writerFor(clazz).withDefaultPrettyPrinter();
            return;
        }
        this.writer = mapper.writerFor(clazz);
    }

    public void marshall(OutputStream outputStream, T object) throws IOException {
        this.writer.writeValue(outputStream, object);
    }

    public void marshall(Writer outputWriter, T object) throws IOException {
        this.writer.writeValue(outputWriter, object);
    }
}

