/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.optional;

import net.anwiba.commons.lang.functional.IAcceptor;
import net.anwiba.commons.lang.functional.IBlock;
import net.anwiba.commons.lang.functional.IConsumer;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.lang.functional.ISupplier;
import net.anwiba.commons.lang.object.ObjectUtilities;
import net.anwiba.commons.lang.optional.IOptional;

public class Optional<T, E extends Exception>
implements IOptional<T, E> {
    private final T value;
    private final IAcceptor<T> acceptor;

    private Optional(IAcceptor<T> acceptor, T value) {
        this.acceptor = acceptor;
        this.value = value;
    }

    public static <T> IOptional<T, RuntimeException> of(T value) {
        return Optional.create(i -> i != null, value);
    }

    public static <T> IOptional<T, RuntimeException> of(IAcceptor<T> acceptor, T value) {
        return Optional.create(acceptor, value);
    }

    public static <T, E extends Exception> IOptional<T, E> create(T value) {
        return Optional.create(i -> i != null, value);
    }

    public static <T, E extends Exception> IOptional<T, E> create(IAcceptor<T> acceptor, T value) {
        return new Optional<T, E>(acceptor, value);
    }

    @Override
    public T get() throws E {
        if (this.isAccepted()) {
            return this.value;
        }
        return null;
    }

    @Override
    public IOptional<T, E> accept(IAcceptor<T> acceptor) throws E {
        if (this.isAccepted()) {
            return new Optional<T, E>(acceptor, this.value);
        }
        return Optional.create(null);
    }

    @Override
    public boolean isAccepted() {
        return this.acceptor.accept(this.value);
    }

    @Override
    public <O> IOptional<O, E> convert(IConverter<T, O, E> converter) throws E {
        if (this.isAccepted()) {
            return Optional.create(converter.convert(this.value));
        }
        return Optional.create(null);
    }

    @Override
    public <O> IOptional<O, E> cast(Class<O> clazz) {
        if (this.isAccepted() && clazz.isInstance(this.value)) {
            return Optional.create(this.value);
        }
        return Optional.create(null);
    }

    @Override
    public IOptional<T, E> consume(IConsumer<T, E> consumer) throws E {
        if (this.isAccepted()) {
            consumer.consume(this.value);
        }
        return this;
    }

    @Override
    public IOptional<T, E> or(IBlock<E> block) throws E {
        if (!this.isAccepted()) {
            block.execute();
        }
        return this;
    }

    @Override
    public IOptional<T, E> or(ISupplier<T, E> supplier) throws E {
        if (!this.isAccepted()) {
            return Optional.create(supplier.supply());
        }
        return this;
    }

    @Override
    public <O> IOptional<T, E> equals(IConverter<T, O, E> converter, O other) throws E {
        if (this.isAccepted() && ObjectUtilities.equals(converter.convert(this.value), other)) {
            return this;
        }
        return Optional.create(null);
    }

    @Override
    public <X extends Exception> T getOrThrow(ISupplier<X, E> supplier) throws E, X {
        if (this.isAccepted()) {
            return this.value;
        }
        throw (Exception)supplier.supply();
    }

    @Override
    public T getOr(ISupplier<T, E> supplier) throws E {
        if (this.isAccepted()) {
            return this.value;
        }
        return supplier.supply();
    }

    @Override
    public IOptional<T, E> or(T value) throws E {
        if (this.isAccepted()) {
            return this;
        }
        return new Optional<T, E>(this.acceptor, value);
    }
}

