/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.stream;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import net.anwiba.commons.lang.collection.IObjectList;
import net.anwiba.commons.lang.collection.ObjectList;
import net.anwiba.commons.lang.functional.IAcceptor;
import net.anwiba.commons.lang.functional.IAggregator;
import net.anwiba.commons.lang.functional.IAssimilator;
import net.anwiba.commons.lang.functional.IConsumer;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.lang.functional.IFactory;
import net.anwiba.commons.lang.functional.IIterable;
import net.anwiba.commons.lang.optional.IOptional;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.lang.stream.ConvertingIterableIterable;
import net.anwiba.commons.lang.stream.CountingIterableIterable;
import net.anwiba.commons.lang.stream.FilteringIterableIterable;
import net.anwiba.commons.lang.stream.IStream;
import net.anwiba.commons.lang.stream.Streams;

class SequencedStream<T, E extends Exception>
implements IStream<T, E> {
    private final IIterable<T, E> iterable;

    SequencedStream(IIterable<T, E> iterable) {
        this.iterable = iterable;
    }

    @Override
    public <O> IStream<O, E> convert(IConverter<T, O, E> converter) {
        return new SequencedStream<T, E>(new ConvertingIterableIterable<Object, O, E>(this.iterable, i -> i != null, converter));
    }

    @Override
    public <O> IStream<O, E> convert(IAggregator<Integer, T, O, E> aggegator) {
        return new SequencedStream<T, E>(new CountingIterableIterable<Object, O, E>(this.iterable, i -> i != null, aggegator));
    }

    @Override
    public IStream<T, E> distinct() {
        HashSet set = new HashSet();
        return this.filter(i -> !set.add(i));
    }

    @Override
    public IStream<T, E> call(IConsumer<T, E> consumer) throws E {
        this.foreach(consumer);
        return this;
    }

    @Override
    public IStream<T, E> filter(IAcceptor<T> acceptor) {
        return new SequencedStream<T, E>(new FilteringIterableIterable<T, E>(this.iterable, acceptor));
    }

    @Override
    public IStream<T, E> notNull() {
        return this.filter(v -> v != null);
    }

    @Override
    public <O> IStream<O, E> instanceOf(Class<O> clazz) {
        return this.filter(i -> clazz.isInstance(i)).convert((T i) -> clazz.cast(i));
    }

    @Override
    public void foreach(IConsumer<T, E> consumer) throws E {
        this.iterable.foreach(consumer);
    }

    @Override
    public void foreach(IAssimilator<Integer, T, E> assimilator) throws E {
        this.iterable.foreach(assimilator);
    }

    @Override
    public IOptional<T, E> first() throws E {
        return Optional.create(this.iterable.first((O v) -> true));
    }

    @Override
    public IOptional<T, E> first(IAcceptor<T> acceptor) throws E {
        return Optional.create(this.iterable.first(acceptor));
    }

    @Override
    public Iterable<T> asIterable() throws E {
        return this.iterable.aggregate(new LinkedList(), (R l, O t) -> {
            l.add(t);
            return l;
        });
    }

    @Override
    public Collection<T> asCollection() throws E {
        return this.asList();
    }

    @Override
    public <O> List<O> asList() throws E {
        return this.iterable.aggregate(new ArrayList(), (R l, O t) -> {
            l.add(t);
            return l;
        });
    }

    @Override
    public IObjectList<T> asObjectList() throws E {
        return new ObjectList(this.asList());
    }

    @Override
    public <O> IOptional<O, E> aggregate(O identity, IAggregator<O, T, O, E> aggegator) throws E {
        return Optional.create(this.iterable.aggregate(identity, aggegator));
    }

    @Override
    public <O> O[] asArray(IntFunction<O[]> factory) throws E {
        return this.asList().toArray(factory.apply(this.asList().size()));
    }

    @Override
    public <K, V> Map<K, V> asMap(IFactory<T, K, E> keyFactrory, IFactory<T, V, E> valueFactrory) throws E {
        return this.iterable.aggregate(new LinkedHashMap(), (R l, O t) -> {
            l.put(keyFactrory.create(t), valueFactrory.create(t));
            return l;
        });
    }

    @Override
    public IStream<T, E> revert() throws E {
        List list = this.asList();
        Collections.reverse(list);
        return Streams.create(list);
    }
}

