/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.stream;

import java.util.Arrays;
import java.util.Collections;
import java.util.NoSuchElementException;
import net.anwiba.commons.lang.functional.IIterable;
import net.anwiba.commons.lang.functional.IIterator;
import net.anwiba.commons.lang.stream.FilteredJavaUtilIterableIterable;
import net.anwiba.commons.lang.stream.FilteringIterableIterable;
import net.anwiba.commons.lang.stream.IStream;
import net.anwiba.commons.lang.stream.SequencedStream;

public class Streams {
    public static Builder<RuntimeException> of() {
        return new Builder<RuntimeException>();
    }

    public static <E extends Exception> Builder<E> create() {
        return new Builder();
    }

    public static <T> IStream<T, RuntimeException> of(IIterable<T, RuntimeException> input) {
        if (input == null) {
            return Streams.create(Collections.emptyList());
        }
        return new SequencedStream<Object, RuntimeException>(new FilteringIterableIterable<Object, RuntimeException>(input, i -> i != null));
    }

    public static <T> IStream<T, RuntimeException> of(Iterable<T> input) {
        if (input == null) {
            return Streams.create(Collections.emptyList());
        }
        return new SequencedStream(new FilteredJavaUtilIterableIterable(input, i -> i != null));
    }

    public static <T> IStream<T, RuntimeException> of(T[] input) {
        if (input == null) {
            return Streams.create(Collections.emptyList());
        }
        return Streams.create(Arrays.asList(input));
    }

    public static <T, E extends Exception> IStream<T, E> create(IIterable<T, E> input) {
        if (input == null) {
            return Streams.create(Collections.emptyList());
        }
        return new SequencedStream<Object, E>(new FilteringIterableIterable<Object, E>(input, i -> i != null));
    }

    public static <T, E extends Exception> IStream<T, E> create(Iterable<T> input) {
        if (input == null) {
            return Streams.create(Collections.emptyList());
        }
        return new SequencedStream(new FilteredJavaUtilIterableIterable(input, i -> i != null));
    }

    public static <T, E extends Exception> IStream<T, E> create(T[] input) {
        if (input == null) {
            return Streams.create(Collections.emptyList());
        }
        return Streams.create(Arrays.asList(input));
    }

    public static final class Builder<E extends Exception>
    extends From<E> {
        public Builder() {
            super(0);
        }

        public From<E> from(int value) {
            return new From(value);
        }
    }

    public static class From<E extends Exception> {
        private final int value;

        public From(int value) {
            this.value = value;
        }

        public IStream<Integer, E> until(int value) {
            final int from = this.value - 1;
            final int until = value;
            return Streams.create(new IIterable<Integer, E>(){

                @Override
                public IIterator<Integer, E> iterator() {
                    return new IIterator<Integer, E>(from){
                        private int last;
                        private Integer value;
                        {
                            this.last = n;
                            this.value = null;
                        }

                        @Override
                        public boolean hasNext() throws Exception {
                            if (this.value != null) {
                                return true;
                            }
                            if (this.last + 1 >= until) {
                                return false;
                            }
                            this.value = ++this.last;
                            return true;
                        }

                        @Override
                        public Integer next() throws Exception {
                            try {
                                if (!this.hasNext()) {
                                    throw new NoSuchElementException();
                                }
                                Integer n = this.value;
                                return n;
                            }
                            finally {
                                this.value = null;
                            }
                        }
                    };
                }
            });
        }
    }
}

