/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.functional;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.anwiba.commons.lang.functional.IAcceptor;
import net.anwiba.commons.lang.stream.Streams;

public class CollectionAcceptorBuilder<T> {
    private final List<IAcceptor<T>> acceptors = new ArrayList<IAcceptor<T>>();
    private IAcceptor<T> otherwise = v -> false;

    public CollectionAcceptorBuilder<T> accept(IAcceptor<T> acceptor) {
        this.acceptors.add(acceptor);
        return this;
    }

    public CollectionAcceptorBuilder<T> otherwise(IAcceptor<T> otherwise) {
        this.otherwise = otherwise;
        return this;
    }

    public IAcceptor<Collection<T>> build() {
        return new CollectionAcceptor<T>(this.acceptors, this.otherwise);
    }

    public static class CollectionAcceptor<T>
    implements IAcceptor<Collection<T>> {
        private final List<IAcceptor<T>> acceptors;
        private final IAcceptor<T> otherwise;

        public CollectionAcceptor(Collection<IAcceptor<T>> acceptors, IAcceptor<T> otherwise) {
            this.acceptors = new ArrayList<IAcceptor<T>>(acceptors);
            this.otherwise = otherwise;
        }

        @Override
        public boolean accept(Collection<T> values) {
            Iterator<IAcceptor<T>> iterator = this.acceptors.iterator();
            return values.size() < this.acceptors.size() ? false : Streams.of(values).aggregate(true, (i, v) -> i != false && iterator.hasNext() ? ((IAcceptor)iterator.next()).accept(v) : this.otherwise.accept(v)).getOr(() -> false);
        }
    }
}

