/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.optional;

import net.anwiba.commons.lang.functional.IBlock;
import net.anwiba.commons.lang.functional.ISupplier;
import net.anwiba.commons.lang.optional.IIf;
import net.anwiba.commons.lang.optional.IOptional;
import net.anwiba.commons.lang.optional.Optional;

public class If
implements IIf {
    private final boolean value;

    public static IIf isTrue(boolean value) {
        return new If(value);
    }

    public static IIf isTrue(Boolean value) {
        return new If(value == null ? false : value);
    }

    public static IIf defined(Object value) {
        return new If(value != null);
    }

    private If(boolean value) {
        this.value = value;
    }

    @Override
    public <O, E extends Exception> IOptional<O, E> excecute(ISupplier<O, E> supplier) throws E {
        if (this.value) {
            return Optional.create(supplier.supply());
        }
        return Optional.create(null);
    }

    @Override
    public <E extends Exception> IIf excecute(IBlock<E> block) throws E {
        if (this.value) {
            block.execute();
        }
        return this;
    }

    @Override
    public <O, E extends Exception> IOptional<O, E> or(ISupplier<O, E> supplier) throws E {
        if (!this.value) {
            return Optional.create(supplier.supply());
        }
        return Optional.create(null);
    }

    @Override
    public <E extends Exception> IIf or(IBlock<E> block) throws E {
        if (!this.value) {
            block.execute();
        }
        return this;
    }
}

