/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.hashable;

import java.text.MessageFormat;
import java.util.Map;

public class MapEntry<K, V>
implements Map.Entry<K, V> {
    final K key;
    V value;

    public MapEntry(K k, V v) {
        this.value = v;
        this.key = k;
    }

    @Override
    public final K getKey() {
        return this.key;
    }

    @Override
    public final V getValue() {
        return this.value;
    }

    @Override
    public final V setValue(V newValue) {
        V oldValue = this.value;
        this.value = newValue;
        return oldValue;
    }

    @Override
    public final boolean equals(Object object) {
        if (!(object instanceof Map.Entry)) {
            return false;
        }
        Map.Entry other = (Map.Entry)object;
        return this.equals(this.getKey(), other.getKey()) && this.equals(this.getValue(), other.getValue());
    }

    private boolean equals(Object value, Object other) {
        return value == other || value != null && value.equals(other);
    }

    @Override
    public final int hashCode() {
        return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
    }

    public final String toString() {
        return MessageFormat.format("{0}={1}", this.getKey(), this.getValue());
    }
}

