/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.stream;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import net.anwiba.commons.lang.functional.IIterable;
import net.anwiba.commons.lang.functional.IIterator;
import net.anwiba.commons.lang.stream.IStream;
import net.anwiba.commons.lang.stream.IterableFilteringIterable;
import net.anwiba.commons.lang.stream.JavaUtilIterableFilteringIterable;
import net.anwiba.commons.lang.stream.SequencedStream;

public class Streams {
    public static Builder<RuntimeException> of() {
        return new Builder<RuntimeException>(RuntimeException.class);
    }

    public static <E extends Exception> Builder<E> create(Class<E> exceptionClass) {
        return new Builder<E>(exceptionClass);
    }

    public static <T> IStream<T, RuntimeException> of(IIterable<T, RuntimeException> input) {
        if (input == null) {
            return Streams.create(RuntimeException.class, Collections.emptyList());
        }
        return new SequencedStream<Object, RuntimeException>(RuntimeException.class, new IterableFilteringIterable<Object, RuntimeException>(input, i -> i != null));
    }

    public static <T> IStream<T, RuntimeException> of(Iterable<T> input) {
        if (input == null) {
            return Streams.create(RuntimeException.class, Collections.emptyList());
        }
        return new SequencedStream<Object, RuntimeException>(RuntimeException.class, new JavaUtilIterableFilteringIterable(input, i -> i != null));
    }

    public static <T> IStream<T, RuntimeException> of(T[] input) {
        if (input == null) {
            return Streams.create(RuntimeException.class, Collections.emptyList());
        }
        return Streams.create(RuntimeException.class, Arrays.asList(input));
    }

    public static IStream<Integer, RuntimeException> of(int[] input) {
        if (input == null) {
            return Streams.create(RuntimeException.class, Collections.emptyList());
        }
        return Streams.create(RuntimeException.class, Arrays.stream(input).boxed().collect(Collectors.toList()));
    }

    public static IStream<Double, RuntimeException> of(double[] input) {
        if (input == null) {
            return Streams.create(RuntimeException.class, Collections.emptyList());
        }
        return Streams.create(RuntimeException.class, Arrays.stream(input).boxed().collect(Collectors.toList()));
    }

    public static <T, E extends Exception> IStream<T, E> create(Class<E> exceptionClass, IIterable<T, E> input) {
        if (input == null) {
            return Streams.create(exceptionClass, Collections.emptyList());
        }
        return new SequencedStream<Object, E>(exceptionClass, new IterableFilteringIterable<Object, E>(input, i -> i != null));
    }

    public static <T, E extends Exception> IStream<T, E> create(Class<E> exceptionClass, Iterable<T> input) {
        if (input == null) {
            return Streams.create(exceptionClass, Collections.emptyList());
        }
        return new SequencedStream<Object, E>(exceptionClass, new JavaUtilIterableFilteringIterable(input, i -> i != null));
    }

    public static <T, E extends Exception> IStream<T, E> create(Class<E> exceptionClass, T[] input) {
        if (input == null) {
            return Streams.create(exceptionClass, Collections.emptyList());
        }
        return Streams.create(exceptionClass, Arrays.asList(input));
    }

    public static <T, E extends Exception> IStream<T, E> create(Class<E> exceptionClass, final Iterator<T> iterator) {
        return Streams.create(exceptionClass, new IIterable<T, E>(){

            @Override
            public IIterator<T, E> iterator() {
                return new IIterator<T, E>(){

                    @Override
                    public boolean hasNext() throws Exception {
                        return iterator.hasNext();
                    }

                    @Override
                    public T next() throws Exception {
                        return iterator.next();
                    }
                };
            }
        });
    }

    public static final class Builder<E extends Exception>
    extends From<E> {
        public Builder(Class<E> exceptionClass) {
            super(exceptionClass, 0);
        }

        public From<E> from(int value) {
            return new From(this.getExceptionClass(), value);
        }
    }

    public static class From<E extends Exception> {
        private final int value;
        private final Class<E> exceptionClass;

        public From(Class<E> exceptionClass, int value) {
            this.exceptionClass = exceptionClass;
            this.value = value;
        }

        Class<E> getExceptionClass() {
            return this.exceptionClass;
        }

        public IStream<Integer, E> until(int value) {
            final int from = this.value - 1;
            final int until = value;
            return Streams.create(this.exceptionClass, new IIterable<Integer, E>(){

                @Override
                public IIterator<Integer, E> iterator() {
                    return new IIterator<Integer, E>(from){
                        private int last;
                        private Integer value;
                        {
                            this.last = n;
                            this.value = null;
                        }

                        @Override
                        public boolean hasNext() throws Exception {
                            if (this.value != null) {
                                return true;
                            }
                            if (this.last + 1 >= until) {
                                return false;
                            }
                            this.value = ++this.last;
                            return true;
                        }

                        @Override
                        public Integer next() throws Exception {
                            try {
                                if (!this.hasNext()) {
                                    throw new NoSuchElementException();
                                }
                                Integer n = this.value;
                                return n;
                            }
                            finally {
                                this.value = null;
                            }
                        }
                    };
                }
            });
        }
    }
}

