/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.anwiba.commons.lang.collection.IMutableObjectCollection;
import net.anwiba.commons.lang.collection.IObjectIterable;
import net.anwiba.commons.lang.collection.IObjectIterator;
import net.anwiba.commons.lang.collection.ObjectList;
import net.anwiba.commons.lang.stream.IStream;
import net.anwiba.commons.lang.stream.Streams;

public abstract class AbstractObjectCollection<T>
implements IMutableObjectCollection<T> {
    private final Object semaphor = new Object();
    private final List<T> objects = new ArrayList<T>();

    public AbstractObjectCollection(List<T> objects) {
        this.objects.addAll(objects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<T> toCollection() {
        Object object = this.semaphor;
        synchronized (object) {
            return Collections.unmodifiableCollection(new ArrayList<T>(this.objects));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<T> toList() {
        Object object = this.semaphor;
        synchronized (object) {
            return Collections.unmodifiableList(new ArrayList<T>(this.objects));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.semaphor;
        synchronized (object) {
            return this.objects.size();
        }
    }

    @Override
    public void set(T ... objects) {
        this.set((Iterable<T>)Arrays.asList(objects));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(Iterable<T> objects) {
        Object object = this.semaphor;
        synchronized (object) {
            this.objects.clear();
            for (T object2 : objects) {
                this.objects.add(object2);
            }
        }
    }

    @Override
    public synchronized void add(T ... objects) {
        this.add((Iterable<T>)Arrays.asList(objects));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Iterable<T> objects) {
        Object object = this.semaphor;
        synchronized (object) {
            for (T object2 : objects) {
                this.objects.add(object2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] indices(Iterable<T> objects) {
        Set set = StreamSupport.stream(objects.spliterator(), false).collect(Collectors.toSet());
        LinkedList<Integer> indexes = new LinkedList<Integer>();
        Object object = this.semaphor;
        synchronized (object) {
            int j = 0;
            while (j < this.objects.size()) {
                if (set.contains(this.objects.get(j))) {
                    indexes.add(j);
                }
                ++j;
            }
            return indexes.stream().mapToInt(i -> i).toArray();
        }
    }

    @Override
    public void remove(T ... objects) {
        int[] indices = this.indices(Arrays.asList(objects));
        this.remove(indices);
    }

    @Override
    public void remove(Iterable<T> objects) {
        int[] indices = this.indices(objects);
        this.remove(indices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(int ... indices) {
        Object object = this.semaphor;
        synchronized (object) {
            if (indices.length == 0) {
                return;
            }
            Arrays.sort(indices);
            ArrayList<T> removedObjects = new ArrayList<T>();
            int i = indices.length - 1;
            while (i >= 0) {
                int index = indices[i];
                T object2 = this.get(index);
                T removedObject = this.objects.remove(index);
                if (removedObject != null) {
                    removedObjects.add(object2);
                }
                --i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final T get(int index) {
        Object object = this.semaphor;
        synchronized (object) {
            block4: {
                if (index != -1) break block4;
                return null;
            }
            return this.objects.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll() {
        Object object = this.semaphor;
        synchronized (object) {
            this.objects.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final IObjectIterable<T> values() {
        Object object = this.semaphor;
        synchronized (object) {
            return new ObjectList(Collections.unmodifiableList(this.objects.stream().collect(Collectors.toList())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isEmpty() {
        Object object = this.semaphor;
        synchronized (object) {
            return this.objects.isEmpty();
        }
    }

    @Override
    public IObjectIterator<T> iterator() {
        final Iterator<T> iterator = this.objects.iterator();
        return new IObjectIterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                return iterator.next();
            }
        };
    }

    @Override
    public IStream<T, RuntimeException> stream() {
        return Streams.of(this.objects);
    }
}

