/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.optional;

import java.util.Objects;
import net.anwiba.commons.lang.functional.IAcceptor;
import net.anwiba.commons.lang.functional.IBlock;
import net.anwiba.commons.lang.functional.IConsumer;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.lang.functional.IFunction;
import net.anwiba.commons.lang.functional.ISupplier;
import net.anwiba.commons.lang.optional.IOptional;

public class Optional<T, E extends Exception> {
    public static <T> IOptional<T, RuntimeException> empty() {
        return Optional.empty(RuntimeException.class);
    }

    public static <T, E extends Exception> IOptional<T, E> empty(Class<E> exceptionClass) {
        return new Empty(exceptionClass);
    }

    public static <T> IOptional<T, RuntimeException> of(T value) {
        return Optional.of(RuntimeException.class, value);
    }

    public static <T> IOptional<T, RuntimeException> of(java.util.Optional<T> optional) {
        return optional.isPresent() ? Optional.of(optional.get()) : Optional.empty();
    }

    public static <T, E extends Exception> IOptional<T, E> of(Class<E> exceptionClass, T value) {
        if (value == null) {
            return Optional.empty(exceptionClass);
        }
        return new Value<T, E>(exceptionClass, value);
    }

    public static <I, O, E extends Exception> IOptional<O, E> bind(IOptional<I, E> optional, IFunction<I, O, E> function) {
        return optional.convert(i -> function.execute(i));
    }

    public static <T, E extends Exception> IOptional<T, E> failed(Class<E> exceptionClass, E cause) {
        return new Failed(exceptionClass, cause);
    }

    private static <T, E extends Exception> IOptional<T, E> failed(Class<E> exceptionClass, Exception exception, E cause) {
        if (cause != null) {
            exception.addSuppressed(cause);
        }
        if (exceptionClass.isInstance(exception)) {
            return new Failed(exceptionClass, exception);
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new RuntimeException(exception.getMessage(), exception);
    }

    static class Empty<T, E extends Exception>
    implements IOptional<T, E> {
        private final Class<E> exceptionClass;

        public Empty(Class<E> exceptionClass) {
            this.exceptionClass = Objects.requireNonNull(exceptionClass);
        }

        @Override
        public IOptional<T, E> or(T value) {
            return Optional.of(this.exceptionClass, value);
        }

        @Override
        public IOptional<T, E> or(IBlock<E> block) {
            try {
                block.execute();
                return this;
            }
            catch (Exception exception) {
                return Optional.failed(this.exceptionClass, exception, null);
            }
        }

        @Override
        public IOptional<T, E> or(ISupplier<T, E> supplier) {
            try {
                return Optional.of(this.exceptionClass, supplier.supply());
            }
            catch (Exception exception) {
                return Optional.failed(this.exceptionClass, exception, null);
            }
        }

        public int hashCode() {
            return Empty.class.hashCode();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            return object instanceof Empty;
        }

        @Override
        public IOptional<T, E> failed(ISupplier<T, E> supplier) {
            return this;
        }

        @Override
        public IOptional<T, E> failed(IConverter<E, T, E> value) {
            return this;
        }

        @Override
        public T get() throws E {
            return null;
        }

        @Override
        public T getObject() {
            throw new IllegalStateException();
        }

        @Override
        public E getCause() {
            throw new IllegalStateException();
        }

        @Override
        public IOptional<T, E> accept(IAcceptor<T> acceptor) {
            return this;
        }

        @Override
        public IOptional<T, E> consume(IConsumer<T, E> converter) {
            return this;
        }

        @Override
        public <O> IOptional<O, E> convert(IConverter<T, O, E> converter) {
            return new Empty<T, E>(this.exceptionClass);
        }

        @Override
        public <O> IOptional<T, E> equals(IConverter<T, O, E> converter, O value) {
            return this;
        }

        @Override
        public <X extends Exception> T getOrThrow(ISupplier<X, E> supplier) throws X, E {
            throw (Exception)supplier.supply();
        }

        @Override
        public <X extends Exception> T getOrThrow(IConverter<E, X, X> converter) throws X {
            throw (Exception)converter.convert(null);
        }

        @Override
        public T getOr(ISupplier<T, E> supplier) throws E {
            return supplier.supply();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean isAccepted() {
            return false;
        }

        @Override
        public boolean isSuccessful() {
            return true;
        }

        @Override
        public <O> IOptional<O, E> instanceOf(Class<O> clazz) {
            return Optional.empty(this.exceptionClass);
        }

        @Override
        public boolean contains(T other) {
            return false;
        }

        @Override
        public java.util.Optional<T> toOptional() {
            return java.util.Optional.empty();
        }
    }

    static class Failed<T, E extends Exception>
    implements IOptional<T, E> {
        private final Class<E> exceptionClass;
        private final E cause;

        public Failed(Class<E> exceptionClass, E cause) {
            this.exceptionClass = Objects.requireNonNull(exceptionClass);
            this.cause = (Exception)Objects.requireNonNull(cause);
        }

        @Override
        public IOptional<T, E> or(T value) {
            return this;
        }

        @Override
        public IOptional<T, E> or(IBlock<E> block) {
            return this;
        }

        @Override
        public IOptional<T, E> or(ISupplier<T, E> supplier) {
            return this;
        }

        @Override
        public IOptional<T, E> failed(ISupplier<T, E> supplier) {
            try {
                return Optional.of(this.exceptionClass, supplier.supply());
            }
            catch (Exception exception) {
                return Optional.failed(this.exceptionClass, exception, this.getCause());
            }
        }

        @Override
        public IOptional<T, E> failed(IConverter<E, T, E> converter) {
            try {
                return Optional.of(this.exceptionClass, converter.convert(this.cause));
            }
            catch (Exception exception) {
                return Optional.failed(this.exceptionClass, exception, this.getCause());
            }
        }

        @Override
        public T get() throws E {
            throw this.cause;
        }

        @Override
        public T getObject() {
            throw new IllegalStateException();
        }

        @Override
        public E getCause() {
            return this.cause;
        }

        @Override
        public IOptional<T, E> accept(IAcceptor<T> acceptor) {
            return this;
        }

        @Override
        public IOptional<T, E> consume(IConsumer<T, E> converter) {
            return this;
        }

        @Override
        public <O> IOptional<O, E> convert(IConverter<T, O, E> converter) {
            return Optional.failed(this.exceptionClass, this.cause);
        }

        @Override
        public <O> IOptional<T, E> equals(IConverter<T, O, E> converter, O value) {
            return Optional.failed(this.exceptionClass, this.cause);
        }

        @Override
        public <X extends Exception> T getOrThrow(ISupplier<X, E> supplier) throws X, E {
            throw this.cause;
        }

        @Override
        public <X extends Exception> T getOrThrow(IConverter<E, X, X> converter) throws X {
            throw (Exception)converter.convert(this.cause);
        }

        @Override
        public T getOr(ISupplier<T, E> supplier) throws E {
            throw this.cause;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean isAccepted() {
            return false;
        }

        @Override
        public boolean isSuccessful() {
            return false;
        }

        @Override
        public <O> IOptional<O, E> instanceOf(Class<O> clazz) {
            return Optional.failed(this.exceptionClass, this.cause);
        }

        @Override
        public boolean contains(T other) {
            return false;
        }

        @Override
        public java.util.Optional<T> toOptional() {
            throw new RuntimeException(((Throwable)this.cause).getMessage(), (Throwable)this.cause);
        }
    }

    static class Value<T, E extends Exception>
    implements IOptional<T, E> {
        private final Class<E> exceptionClass;
        private final T value;

        public Value(Class<E> exceptionClass, T value) {
            this.exceptionClass = Objects.requireNonNull(exceptionClass);
            this.value = Objects.requireNonNull(value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof Value) {
                Value other = (Value)object;
                return Objects.equals(this.value, other.value);
            }
            return false;
        }

        @Override
        public IOptional<T, E> or(T other) {
            return this;
        }

        @Override
        public IOptional<T, E> or(IBlock<E> block) {
            return this;
        }

        @Override
        public IOptional<T, E> or(ISupplier<T, E> supplier) {
            return this;
        }

        @Override
        public IOptional<T, E> failed(ISupplier<T, E> supplier) {
            return this;
        }

        @Override
        public IOptional<T, E> failed(IConverter<E, T, E> converter) {
            return this;
        }

        @Override
        public T get() throws E {
            return this.value;
        }

        @Override
        public T getObject() {
            return this.value;
        }

        @Override
        public E getCause() {
            throw new IllegalStateException();
        }

        @Override
        public IOptional<T, E> accept(IAcceptor<T> acceptor) {
            return acceptor.accept(this.value) ? this : Optional.empty(this.exceptionClass);
        }

        @Override
        public IOptional<T, E> consume(IConsumer<T, E> consumer) {
            try {
                consumer.consume(this.value);
                return this;
            }
            catch (Exception exception) {
                return Optional.failed(this.exceptionClass, exception, null);
            }
        }

        @Override
        public <O> IOptional<O, E> convert(IConverter<T, O, E> converter) {
            try {
                return Optional.of(this.exceptionClass, converter.convert(this.value));
            }
            catch (Exception exception) {
                return Optional.failed(this.exceptionClass, exception, null);
            }
        }

        @Override
        public <O> IOptional<T, E> equals(IConverter<T, O, E> converter, O other) {
            try {
                if (Objects.equals(converter.convert(this.value), other)) {
                    return this;
                }
                return Optional.empty(this.exceptionClass);
            }
            catch (Exception exception) {
                return Optional.failed(this.exceptionClass, exception, null);
            }
        }

        @Override
        public <O> IOptional<O, E> instanceOf(Class<O> clazz) {
            if (clazz.isInstance(this.value)) {
                return Optional.of(this.exceptionClass, this.value);
            }
            return Optional.empty(this.exceptionClass);
        }

        @Override
        public <X extends Exception> T getOrThrow(ISupplier<X, E> supplier) throws X, E {
            return this.value;
        }

        @Override
        public <X extends Exception> T getOrThrow(IConverter<E, X, X> supplier) throws X {
            return this.value;
        }

        @Override
        public T getOr(ISupplier<T, E> supplier) throws E {
            return this.value;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean isAccepted() {
            return true;
        }

        @Override
        public boolean isSuccessful() {
            return true;
        }

        @Override
        public boolean contains(T other) {
            return Objects.equals(this.value, other);
        }

        @Override
        public java.util.Optional<T> toOptional() {
            return java.util.Optional.of(this.value);
        }
    }
}

