/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.stream;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.IntFunction;
import net.anwiba.commons.lang.collection.IObjectList;
import net.anwiba.commons.lang.functional.IAcceptor;
import net.anwiba.commons.lang.functional.IAggregator;
import net.anwiba.commons.lang.functional.IAssimilator;
import net.anwiba.commons.lang.functional.IConsumer;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.lang.functional.IFactory;
import net.anwiba.commons.lang.functional.ISupplier;
import net.anwiba.commons.lang.optional.IOptional;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.lang.stream.IStream;
import net.anwiba.commons.lang.stream.Streams;

public class FailedStream<T, E extends Exception>
implements IStream<T, E> {
    private final Class<E> exceptionClass;
    private final E cause;

    FailedStream(Class<E> exceptionClass, E cause) {
        this.exceptionClass = Objects.requireNonNull(exceptionClass);
        this.cause = (Exception)Objects.requireNonNull(cause);
    }

    @Override
    public IStream<T, E> distinct() {
        return this;
    }

    @Override
    public IStream<T, E> filter(IAcceptor<T> funtion) {
        return this;
    }

    @Override
    public <O> IStream<O, E> convert(IConverter<T, O, E> funtion) {
        return new FailedStream<T, E>(this.exceptionClass, this.cause);
    }

    @Override
    public <O> IStream<O, E> flat(IConverter<T, Iterable<O>, E> funtion) {
        return new FailedStream<T, E>(this.exceptionClass, this.cause);
    }

    @Override
    public <O> IStream<O, E> convert(IAggregator<Integer, T, O, E> aggregator) {
        return new FailedStream<T, E>(this.exceptionClass, this.cause);
    }

    @Override
    public IStream<T, E> failed(ISupplier<Iterable<T>, E> supplier) {
        try {
            return Streams.of(this.exceptionClass, supplier.supply());
        }
        catch (Exception exception) {
            return FailedStream.stream(this.exceptionClass, exception);
        }
    }

    @Override
    public IStream<T, E> foreach(IConsumer<T, E> consumer) {
        return this;
    }

    @Override
    public IStream<T, E> foreach(IAssimilator<Integer, T, E> assimilator) {
        return this;
    }

    @Override
    public IStream<T, E> notNull() {
        return this;
    }

    @Override
    public IStream<T, E> revert() {
        return this;
    }

    @Override
    public <O> IStream<O, E> instanceOf(Class<O> clazz) {
        return new FailedStream<T, E>(this.exceptionClass, this.cause);
    }

    @Override
    public <O> O[] asArray(IntFunction<O[]> function) throws E {
        throw this.cause;
    }

    @Override
    public Iterable<T> asIterable() throws E {
        throw this.cause;
    }

    @Override
    public Collection<T> asCollection() throws E {
        throw this.cause;
    }

    @Override
    public <O> List<O> asList() throws E {
        throw this.cause;
    }

    @Override
    public <O> Set<O> asSet() throws E {
        throw this.cause;
    }

    @Override
    public <K, V> Map<K, V> asMap(IFactory<T, K, E> keyFactrory, IFactory<T, V, E> valueFactrory) throws E {
        throw this.cause;
    }

    @Override
    public IObjectList<T> asObjectList() throws E {
        throw this.cause;
    }

    @Override
    public IOptional<T, E> first() {
        return Optional.failed(this.exceptionClass, this.cause);
    }

    @Override
    public IOptional<T, E> first(IAcceptor<T> acceptor) {
        return Optional.failed(this.exceptionClass, this.cause);
    }

    @Override
    public <O> IOptional<O, E> aggregate(O inital, IAggregator<O, T, O, E> aggregator) {
        return Optional.failed(this.exceptionClass, this.cause);
    }

    private static <T, E extends Exception> IStream<T, E> stream(Class<E> exceptionClass, Exception exception) {
        if (exceptionClass.isInstance(exception)) {
            return new FailedStream<T, Exception>(exceptionClass, exception);
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new RuntimeException(exception.getMessage(), exception);
    }
}

