/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.comparable;

import java.text.DecimalFormatSymbols;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import net.anwiba.commons.lang.counter.IIntCounter;
import net.anwiba.commons.lang.counter.IntCounter;

public class SortItemIterator
implements Iterator<Object> {
    private final char[] array;
    private final IIntCounter counter = new IntCounter(-1);
    private Object item = null;
    private final Locale locale = Locale.getDefault();
    private final DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(this.locale);

    public SortItemIterator(String string) {
        this.array = string.toCharArray();
    }

    @Override
    public Object next() {
        if (this.item == null && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            Object object = this.item;
            return object;
        }
        finally {
            this.item = null;
        }
    }

    @Override
    public boolean hasNext() {
        if (this.item != null) {
            return true;
        }
        if (this.counter.value() + 1 < this.array.length) {
            char c = this.array[this.counter.next()];
            if (this.isDigit(c)) {
                this.item = this.getNumber(this.array);
                return true;
            }
            if ((this.isDecimalSeparator(c) || this.isSign(c)) && this.counter.value() + 1 < this.array.length && this.isDigit(this.array[this.counter.value() + 1]) && (this.counter.value() == 0 || this.isWhitespace(this.array[this.counter.value() - 1]))) {
                this.item = this.getNumber(this.array);
                return true;
            }
            this.item = String.valueOf(c);
            return true;
        }
        return false;
    }

    private Object getNumber(char[] chars) {
        StringBuilder builder = new StringBuilder();
        this.append(builder, chars[this.counter.value()]);
        int index = this.counter.value() + 1;
        boolean isDouble = false;
        while (index < chars.length && (this.isDigit(chars[index]) || this.isSeperator(chars[index]))) {
            isDouble = isDouble || this.isDecimalSeparator(chars[index]);
            this.append(builder, chars[index]);
            index = this.counter.next() + 1;
        }
        return isDouble ? Double.valueOf(builder.toString()) : (double)Long.valueOf(builder.toString()).longValue();
    }

    private void append(StringBuilder builder, char c) {
        if (this.isDecimalSeparator(c)) {
            builder.append('.');
        } else if (!this.isGroupingSeparator(c)) {
            builder.append(c);
        }
    }

    private boolean isWhitespace(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n';
    }

    private boolean isSign(char c) {
        return c == '-' || c == '+';
    }

    private boolean isSeperator(char c) {
        return this.isGroupingSeparator(c) || this.isDecimalSeparator(c);
    }

    private boolean isDecimalSeparator(char c) {
        return this.decimalFormatSymbols.getDecimalSeparator() == c;
    }

    private boolean isGroupingSeparator(char c) {
        return this.decimalFormatSymbols.getGroupingSeparator() == c;
    }

    private boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

