/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.hashable;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.anwiba.commons.lang.hashable.HashableWrapper;
import net.anwiba.commons.lang.hashable.IHashable;
import net.anwiba.commons.lang.hashable.MapEntry;

public final class HashableEntrySet<K extends IHashable, V>
extends AbstractSet<Map.Entry<K, V>>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -7023287624783829656L;
    private final HashSet<Map.Entry<HashableWrapper<K>, V>> set;

    HashableEntrySet(HashSet<Map.Entry<HashableWrapper<K>, V>> clone) {
        this.set = clone;
    }

    public HashableEntrySet() {
        this.set = new HashSet();
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public boolean contains(Object object) {
        if (object == null) {
            return this.set.contains(null);
        }
        if (!(object instanceof Map.Entry)) {
            return false;
        }
        Map.Entry entry = (Map.Entry)object;
        if (!(entry.getKey() instanceof IHashable)) {
            return false;
        }
        IHashable hashable = (IHashable)entry.getKey();
        MapEntry o = new MapEntry(new HashableWrapper<IHashable>(hashable), entry.getValue());
        return this.set.contains(o);
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        final Iterator<Map.Entry<HashableWrapper<K>, V>> iterator = this.set.iterator();
        return new Iterator<Map.Entry<K, V>>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Map.Entry<K, V> next() {
                Map.Entry next = (Map.Entry)iterator.next();
                return new MapEntry(((HashableWrapper)next.getKey()).getValue(), next.getValue());
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    @Override
    public boolean add(Map.Entry<K, V> entry) {
        if (entry == null) {
            return this.set.add(null);
        }
        return this.set.add(new MapEntry<HashableWrapper<IHashable>, V>(new HashableWrapper<IHashable>((IHashable)entry.getKey()), entry.getValue()));
    }

    @Override
    public boolean remove(Object object) {
        if (object == null) {
            return this.set.remove(null);
        }
        if (!(object instanceof Map.Entry)) {
            return false;
        }
        Map.Entry entry = (Map.Entry)object;
        if (!(entry.getKey() instanceof IHashable)) {
            return false;
        }
        IHashable hashable = (IHashable)entry.getKey();
        MapEntry o = new MapEntry(new HashableWrapper<IHashable>(hashable), entry.getValue());
        return this.set.remove(o);
    }

    @Override
    public void clear() {
        this.set.clear();
    }

    public HashableEntrySet<K, V> clone() {
        return new HashableEntrySet<K, V>((HashSet)this.set.clone());
    }
}

