/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.stream;

import java.util.NoSuchElementException;
import net.anwiba.commons.lang.functional.IAcceptor;
import net.anwiba.commons.lang.functional.IIterator;

public final class FilteringIteratorIterator<T, E extends Exception>
implements IIterator<T, E> {
    private final IIterator<T, E> iterator;
    private final IAcceptor<T> acceptor;
    private T item = null;

    public FilteringIteratorIterator(IIterator<T, E> input, IAcceptor<T> acceptor) {
        this.iterator = input;
        this.acceptor = acceptor;
    }

    @Override
    public boolean hasNext() throws E {
        while (this.iterator.hasNext()) {
            T i = this.iterator.next();
            if (!this.acceptor.accept(i) || (this.item = i) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public T next() throws E {
        try {
            if (this.item != null || this.hasNext()) {
                T t = this.item;
                return t;
            }
            throw new NoSuchElementException();
        }
        finally {
            this.item = null;
        }
    }
}

