/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.tree.converter;

import net.anwiba.commons.lang.object.IObjectToStringConverter;
import net.anwiba.commons.lang.tree.ITreeItem;
import net.anwiba.commons.lang.tree.Tree;
import net.anwiba.commons.lang.tree.converter.ItemToStringConverter;

public class TreeToStringConverter<K, V>
implements IObjectToStringConverter<Tree<K, V>> {
    private final ItemToStringConverter<K, V> converter;
    private int format;

    public TreeToStringConverter() {
        this(1);
    }

    public TreeToStringConverter(int format) {
        this.format = format;
        this.converter = new ItemToStringConverter(format);
    }

    @Override
    public String toString(Tree<K, V> tree) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("size: ");
        stringBuilder.append(tree.size());
        stringBuilder.append("\n");
        if (tree.getFirst() != null && this.format == 1) {
            stringBuilder.append("list: ");
            stringBuilder.append(this.list(tree.getFirst()));
        }
        if (tree.getRoot() != null) {
            stringBuilder.append("tree: ");
            stringBuilder.append(this.tree(tree.getRoot()));
        }
        return stringBuilder.toString();
    }

    private String list(ITreeItem<K, V> first) {
        if (first == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n");
        ITreeItem<K, V> item = first;
        do {
            buffer.append("    ");
            buffer.append(this.converter.toString(item));
            buffer.append("\n");
        } while ((item = item.getNext()) != null);
        return buffer.toString();
    }

    private String tree(ITreeItem<K, V> item) {
        if (item == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n");
        this.tree(buffer, 0, item);
        return buffer.toString();
    }

    private void tree(StringBuffer buffer, int depth, ITreeItem<K, V> item) {
        buffer.append("    ");
        if (depth > 0) {
            int i = 0;
            while (i < depth - 1) {
                buffer.append("|    ");
                ++i;
            }
            buffer.append("+--> ");
        }
        buffer.append(this.converter.toString(item));
        buffer.append("\n");
        if (item.getLeft() != null) {
            this.tree(buffer, depth + 1, item.getLeft());
        }
        if (item.getRight() != null) {
            this.tree(buffer, depth + 1, item.getRight());
        }
    }
}

