/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.tree;

import java.util.Comparator;
import net.anwiba.commons.lang.collection.IObjectIteratorFactory;
import net.anwiba.commons.lang.exception.UnreachableCodeReachedException;
import net.anwiba.commons.lang.tree.ITree;
import net.anwiba.commons.lang.tree.ITreeItem;
import net.anwiba.commons.lang.tree.ITreeItemChooser;
import net.anwiba.commons.lang.tree.TreeItem;
import net.anwiba.commons.lang.tree.TreeItemChooser;
import net.anwiba.commons.lang.tree.distance.IObjectDistanceCalculator;
import net.anwiba.commons.lang.tree.iterator.BreadthFirstSearchValueIteratorFactory;
import net.anwiba.commons.lang.tree.iterator.DeepFirstSearchValueIteratorFactory;
import net.anwiba.commons.lang.tree.iterator.SortedKeyIteratorFactory;
import net.anwiba.commons.lang.tree.iterator.SortedValueIteratorFactory;
import net.anwiba.commons.lang.tree.iterator.TreeIterable;
import net.anwiba.commons.lang.tree.walker.ITreeWalker;
import net.anwiba.commons.lang.tree.walker.TreeWalker;

public class Tree<K, V>
implements ITree<K, V> {
    private TreeItem<K, V> first = null;
    private TreeItem<K, V> last = null;
    private TreeItem<K, V> root = null;
    private int numberOfItems = 0;
    private final int maximumOfItems;
    private Comparator<K> comparator;
    private ITreeItemChooser<K, V> treeItemChooser;

    public Tree(Comparator<K> comparator) {
        this(comparator, Integer.MAX_VALUE, new TreeItemChooser(new IObjectDistanceCalculator<K>(){

            @Override
            public double calculate(K object, K other) {
                return Double.NaN;
            }
        }));
    }

    public Tree(Comparator<K> comparator, int maximumOfItems, ITreeItemChooser<K, V> treeItemChooser) {
        this.comparator = comparator;
        this.maximumOfItems = maximumOfItems;
        this.treeItemChooser = treeItemChooser;
    }

    @Override
    public void insert(K key, V element) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (element == null) {
            throw new NullPointerException();
        }
        if (this.root == null) {
            this.root = new TreeItem<K, V>(key, element);
            this.first = this.root;
            this.last = this.root;
            ++this.numberOfItems;
        } else {
            this.insert(this.root, key, element);
        }
    }

    private boolean insert(TreeItem<K, V> item, K key, V element) {
        if (item == null) {
            throw new NullPointerException();
        }
        if (element == null) {
            throw new NullPointerException();
        }
        if (this.comparator.compare(key, item.getKey()) < 0) {
            if (item.left == null) {
                if (this.numberOfItems >= this.maximumOfItems) {
                    this.changeItemIfNecesary(item, key, element);
                    return false;
                }
                item.left = new TreeItem<K, V>(key, element);
                item.left.parent = item;
                --item.balanced;
                item.left.next = item;
                item.left.prev = item.prev;
                item.prev = item.left;
                if (item.left.prev != null) {
                    item.left.prev.next = item.left;
                } else {
                    this.first = item.left;
                }
                ++this.numberOfItems;
                return item.right == null;
            }
            if (this.insert(item.left, key, element)) {
                switch (item.balanced) {
                    case 0: {
                        item.balanced = -1;
                        return true;
                    }
                    case 1: {
                        item.balanced = 0;
                        return false;
                    }
                    case -1: {
                        if (item.left.balanced == 1) {
                            this.leftRightRotation(item);
                        } else {
                            this.rightRotation(item);
                        }
                        item.balanced = 0;
                        return false;
                    }
                }
                throw new UnreachableCodeReachedException();
            }
            return false;
        }
        if (this.comparator.compare(key, item.getKey()) > 0) {
            if (item.right == null) {
                if (this.numberOfItems >= this.maximumOfItems) {
                    this.changeItemIfNecesary(item, key, element);
                    return false;
                }
                item.right = new TreeItem<K, V>(key, element);
                item.right.parent = item;
                ++item.balanced;
                item.right.prev = item;
                item.right.next = item.next;
                item.next = item.right;
                if (item.right.next != null) {
                    item.right.next.prev = item.right;
                } else {
                    this.last = item.right;
                }
                ++this.numberOfItems;
                return item.left == null;
            }
            if (this.insert(item.right, key, element)) {
                switch (item.balanced) {
                    case 0: {
                        item.balanced = 1;
                        return true;
                    }
                    case -1: {
                        item.balanced = 0;
                        return false;
                    }
                    case 1: {
                        if (item.right.balanced == -1) {
                            this.rightLeftRotation(item);
                        } else {
                            this.leftRotation(item);
                        }
                        item.balanced = 0;
                        return false;
                    }
                }
                throw new UnreachableCodeReachedException();
            }
            return false;
        }
        item.setElement(element);
        return false;
    }

    private void changeItemIfNecesary(TreeItem<K, V> item, K key, V element) {
        TreeItem<K, V> choosed = this.choose(item, key, element);
        if (choosed == null) {
            this.treeItemChooser.removed(key);
            return;
        }
        this.replace(choosed, new TreeItem<K, V>(key, element));
    }

    private final TreeItem<K, V> choose(TreeItem<K, V> item, K key, V element) {
        K itemKey = item.getKey();
        int compareResult = this.comparator.compare(itemKey, key);
        if (compareResult == 0) {
            return null;
        }
        if (item.getPrevious() == null) {
            if (compareResult > 0) {
                return item;
            }
            K choosed = this.treeItemChooser.choose(this.comparator, item.next, key, element);
            if (choosed == key) {
                return item.next;
            }
            return null;
        }
        if (item.getNext() == null) {
            if (compareResult < 0) {
                return item;
            }
            K choosed = this.treeItemChooser.choose(this.comparator, item.prev, key, element);
            if (choosed == key) {
                return item.prev;
            }
            return null;
        }
        K choosed = this.treeItemChooser.choose(this.comparator, item, key, element);
        if (choosed == key) {
            return item;
        }
        if (compareResult < 0) {
            if (item.next.next != null && (choosed = this.treeItemChooser.choose(this.comparator, item.next, key, element)) == key) {
                return item.next;
            }
            return null;
        }
        if (compareResult > 0) {
            if (item.prev.prev != null && (choosed = this.treeItemChooser.choose(this.comparator, item.prev, key, element)) == key) {
                return item.prev;
            }
            return null;
        }
        return null;
    }

    private void replace(TreeItem<K, V> item, TreeItem<K, V> with) {
        this.treeItemChooser.removed(item.getKey());
        with.balanced = item.balanced;
        with.left = item.left;
        if (with.left != null) {
            with.left.parent = with;
        }
        with.right = item.right;
        if (with.right != null) {
            with.right.parent = with;
        }
        with.parent = item.parent;
        if (with.parent != null) {
            if (with.parent.left == item) {
                with.parent.left = with;
            }
            if (with.parent.right == item) {
                with.parent.right = with;
            }
        }
        with.next = item.next;
        if (with.next != null) {
            with.next.prev = with;
        }
        with.prev = item.prev;
        if (with.prev != null) {
            with.prev.next = with;
        }
        if (this.root == item) {
            this.root = with;
        }
        if (this.last == item) {
            this.last = with;
        }
        if (this.first == item) {
            this.first = with;
        }
    }

    @Override
    public void removeAll() {
        TreeItem<K, V> item = this.first;
        TreeItem next = null;
        while (item != null) {
            this.treeItemChooser.removed(item.getKey());
            next = item.next;
            item.prev = null;
            item.next = null;
            item.right = null;
            item.left = null;
            item.parent = null;
            item = next;
        }
        this.first = null;
        this.last = null;
        this.root = null;
        this.numberOfItems = 0;
    }

    @Override
    public V get(K element) {
        if (element == null) {
            return null;
        }
        return this.get(this.root, element);
    }

    private V get(TreeItem<K, V> item, K key) {
        if (item == null) {
            return null;
        }
        if (this.comparator.compare(key, item.getKey()) < 0) {
            return this.get(item.left, key);
        }
        if (this.comparator.compare(key, item.getKey()) > 0) {
            return this.get(item.right, key);
        }
        return item.getElement();
    }

    @Override
    public void remove(K key) {
        this.remove(this.root, key);
    }

    public boolean remove(TreeItem<K, V> item, K key) {
        if (item == null) {
            return false;
        }
        if (this.comparator.compare(key, item.getKey()) < 0) {
            if (this.remove(item.left, key)) {
                return this.rebalanceLeft(item);
            }
            return false;
        }
        if (this.comparator.compare(key, item.getKey()) > 0) {
            if (this.remove(item.right, key)) {
                return this.rebalanceRight(item);
            }
            return false;
        }
        boolean shorted = false;
        this.treeItemChooser.removed(key);
        shorted = item.left == null && item.right == null ? this.removeChildLessItem(item) : (item.left == null ? this.removeRightChild(item) : (item.right == null ? this.removeLeftChild(item) : this.removeItemWithBothChildren(item)));
        if (item.next != null && item.prev != null) {
            item.next.prev = item.prev;
            item.prev.next = item.next;
        } else if (item.next != null) {
            item.next.prev = null;
        } else if (item.prev != null) {
            item.prev.next = null;
        }
        return shorted;
    }

    private boolean removeItemWithBothChildren(TreeItem<K, V> item) {
        TreeItem rightLeastItem = this.getMinItem(item.right);
        boolean shorted = this.remove(item, rightLeastItem.getKey());
        rightLeastItem.left = item.left;
        if (item.left != null) {
            rightLeastItem.left.parent = rightLeastItem;
        }
        rightLeastItem.right = item.right;
        if (item.right != null) {
            rightLeastItem.right.parent = rightLeastItem;
        }
        rightLeastItem.parent = item.parent;
        if (rightLeastItem.next != null) {
            rightLeastItem.next.prev = rightLeastItem;
        }
        if (rightLeastItem.prev != null) {
            rightLeastItem.prev.next = rightLeastItem;
        }
        if (item.parent != null) {
            if (item.parent.left == item) {
                item.parent.left = rightLeastItem;
            } else {
                item.parent.right = rightLeastItem;
            }
        }
        if (this.first == item) {
            this.first = rightLeastItem;
        }
        if (this.last == item) {
            this.last = rightLeastItem;
        }
        if (this.root == item) {
            this.root = rightLeastItem;
        }
        if (shorted) {
            shorted = this.rebalanceRight(item);
        }
        return shorted;
    }

    private boolean removeLeftChild(TreeItem<K, V> item) {
        item.left.parent = item.parent;
        if (item.parent != null) {
            if (item.parent.left == item) {
                item.parent.left = item.left;
            } else {
                item.parent.right = item.left;
            }
        }
        --this.numberOfItems;
        if (this.first == item) {
            this.first = item.next;
        }
        if (this.root == item) {
            this.root = item.left;
        }
        return true;
    }

    private boolean removeRightChild(TreeItem<K, V> item) {
        item.right.parent = item.parent;
        if (item.parent != null) {
            if (item.parent.left == item) {
                item.parent.left = item.right;
            } else {
                item.parent.right = item.right;
            }
        }
        --this.numberOfItems;
        if (this.last == item) {
            this.last = item.prev;
        }
        if (this.root == item) {
            this.root = item.right;
        }
        return true;
    }

    private boolean removeChildLessItem(TreeItem<K, V> item) {
        if (item.parent != null) {
            if (item.parent.left == item) {
                item.parent.left = null;
            } else {
                item.parent.right = null;
            }
        }
        --this.numberOfItems;
        if (this.first == item) {
            this.first = item.next;
        }
        if (this.last == item) {
            this.last = item.prev;
        }
        if (this.root == item) {
            this.root = null;
        }
        return true;
    }

    private TreeItem<K, V> getMinItem(TreeItem<K, V> item) {
        if (item.left == null) {
            return item;
        }
        return this.getMinItem(item.left);
    }

    @Override
    public int size() {
        return this.numberOfItems;
    }

    @Override
    public boolean isEmpty() {
        return this.root == null;
    }

    private boolean rebalanceRight(TreeItem<K, V> item) {
        int balanced = item.left != null ? item.left.balanced : 0;
        switch (item.balanced) {
            case 1: {
                item.balanced = 0;
                return true;
            }
            case 0: {
                item.balanced = -1;
                return false;
            }
            case -1: {
                switch (balanced) {
                    case 1: {
                        this.leftRightRotation(item);
                        return true;
                    }
                    case 0: {
                        TreeItem<K, V> dummy = this.rightRotation(item);
                        dummy.right.balanced = -1;
                        dummy.balanced = 1;
                        return false;
                    }
                    case -1: {
                        TreeItem<K, V> dummy = this.rightRotation(item);
                        dummy.right.balanced = 0;
                        dummy.balanced = 0;
                        return true;
                    }
                }
                throw new UnreachableCodeReachedException();
            }
        }
        throw new UnreachableCodeReachedException();
    }

    private boolean rebalanceLeft(TreeItem<K, V> item) {
        int balanced = item.right != null ? item.right.balanced : 0;
        switch (item.balanced) {
            case -1: {
                item.balanced = 0;
                return true;
            }
            case 0: {
                item.balanced = 1;
                return false;
            }
            case 1: {
                switch (balanced) {
                    case -1: {
                        this.rightLeftRotation(item);
                        return true;
                    }
                    case 0: {
                        TreeItem<K, V> dummy = this.leftRotation(item);
                        dummy.left.balanced = 1;
                        dummy.balanced = -1;
                        return false;
                    }
                    case 1: {
                        TreeItem<K, V> dummy = this.leftRotation(item);
                        dummy.left.balanced = 0;
                        dummy.balanced = 0;
                        return true;
                    }
                }
                throw new UnreachableCodeReachedException();
            }
        }
        throw new UnreachableCodeReachedException();
    }

    private TreeItem<K, V> leftRotation(TreeItem<K, V> item) {
        TreeItem parent = item.parent;
        TreeItem result = item.right;
        result.parent = parent;
        if (parent != null) {
            if (parent.left == item) {
                parent.left = result;
            } else {
                parent.right = result;
            }
        }
        item.right = result.left;
        if (item.right != null) {
            item.right.parent = item;
            item.balanced = item.left == null ? 1 : 0;
        } else {
            item.balanced = item.left == null ? 0 : -1;
        }
        result.balanced = 0;
        result.left = item;
        result.left.parent = result;
        if (item == this.root) {
            this.root = result;
        }
        return result;
    }

    private TreeItem<K, V> rightRotation(TreeItem<K, V> item) {
        TreeItem parent = item.parent;
        TreeItem result = item.left;
        result.parent = parent;
        if (parent != null) {
            if (parent.left == item) {
                parent.left = result;
            } else {
                parent.right = result;
            }
        }
        item.left = result.right;
        if (item.left != null) {
            item.left.parent = item;
            item.balanced = item.right == null ? -1 : 0;
        } else {
            item.balanced = item.right == null ? 0 : 1;
        }
        result.balanced = 0;
        result.right = item;
        result.right.parent = result;
        if (item == this.root) {
            this.root = result;
        }
        return result;
    }

    private void leftRightRotation(TreeItem<K, V> item) {
        this.leftRotation(item.left);
        this.rightRotation(item);
    }

    private void rightLeftRotation(TreeItem<K, V> item) {
        this.rightRotation(item.right);
        this.leftRotation(item);
    }

    @Override
    public Iterable<V> getValues() {
        return this.createIterable(new SortedValueIteratorFactory());
    }

    @Override
    public Iterable<V> getDeepSearchFirstValues() {
        return this.createIterable(new DeepFirstSearchValueIteratorFactory(), this.root);
    }

    @Override
    public Iterable<V> getBreadthSearchFirstValues() {
        return this.createIterable(new BreadthFirstSearchValueIteratorFactory(), this.root);
    }

    private <O> TreeIterable<K, V, O> createIterable(IObjectIteratorFactory<ITreeItem<K, V>, O> factory, TreeItem<K, V> item) {
        return new TreeIterable<K, V, O>(factory, item);
    }

    private <O> TreeIterable<K, V, O> createIterable(IObjectIteratorFactory<ITreeItem<K, V>, O> factory) {
        return this.createIterable(factory, this.first);
    }

    @Override
    public Iterable<K> getKeys() {
        return this.createIterable(new SortedKeyIteratorFactory());
    }

    @Override
    public ITreeWalker<K, V> getTreeWalker() {
        return new TreeWalker<K, V>(this.first, this.root);
    }

    public ITreeItem<K, V> getRoot() {
        return this.root;
    }

    public ITreeItem<K, V> getFirst() {
        return this.first;
    }

    public ITreeItem<K, V> getLast() {
        return this.last;
    }
}

