/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.tree.converter;

import net.anwiba.commons.lang.object.IObjectToStringConverter;
import net.anwiba.commons.lang.tree.ITreeItem;

public class ItemToStringConverter<K, V>
implements IObjectToStringConverter<ITreeItem<K, V>> {
    public static final int SIMPLE = 0;
    public static final int COMPLEX = 1;
    private final int format;

    public ItemToStringConverter() {
        this(1);
    }

    public ItemToStringConverter(int format) {
        this.format = format;
    }

    @Override
    public String toString(ITreeItem<K, V> item) {
        StringBuffer buffer = new StringBuffer();
        if (this.format == 0) {
            buffer.append(item.getKey());
            return buffer.toString();
        }
        buffer.append(item.getKey());
        buffer.append(" : ");
        buffer.append(item.getElement());
        buffer.append(" ( ");
        if (item.getParent() != null) {
            buffer.append("p:");
            buffer.append(item.getParent().getKey());
        } else {
            buffer.append("null");
        }
        buffer.append(", ");
        if (item.getLeft() != null) {
            buffer.append("l:");
            buffer.append(item.getLeft().getKey());
        } else {
            buffer.append("null");
        }
        buffer.append(", ");
        if (item.getRight() != null) {
            buffer.append("r:");
            buffer.append(item.getRight().getKey());
        } else {
            buffer.append("null");
        }
        buffer.append("; ");
        if (item.getPrevious() != null) {
            buffer.append("f:");
            buffer.append(item.getPrevious().getKey());
        } else {
            buffer.append("null");
        }
        buffer.append(", ");
        if (item.getNext() != null) {
            buffer.append("n:");
            buffer.append(item.getNext().getKey());
        } else {
            buffer.append("null");
        }
        buffer.append(") [ ").append(item.getBalanced()).append(" ]");
        return buffer.toString();
    }
}

