/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.hashable;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.anwiba.commons.lang.hashable.HashableEntrySet;
import net.anwiba.commons.lang.hashable.HashableSet;
import net.anwiba.commons.lang.hashable.HashableWrapper;
import net.anwiba.commons.lang.hashable.IHashable;

public final class HashableMap<K extends IHashable, V>
implements Map<K, V>,
Serializable,
Cloneable {
    private static final long serialVersionUID = -3641759535670670188L;
    final HashMap<HashableWrapper<K>, V> map;

    public HashableMap() {
        this.map = new HashMap();
    }

    public HashableMap(int initialCapacity) {
        this.map = new HashMap(initialCapacity);
    }

    public HashableMap(int initialCapacity, float loadFactor) {
        this.map = new HashMap(initialCapacity, loadFactor);
    }

    HashableMap(HashMap<HashableWrapper<K>, V> map) {
        this.map = map;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public V put(K key, V value) {
        return this.map.put(new HashableWrapper<K>(key), value);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public boolean containsKey(Object key) {
        if (key != null && !(key instanceof IHashable)) {
            return false;
        }
        IHashable hashable = (IHashable)key;
        return this.map.containsKey(new HashableWrapper<IHashable>(hashable));
    }

    @Override
    public V get(Object key) {
        if (key != null && !(key instanceof IHashable)) {
            return null;
        }
        IHashable hashable = (IHashable)key;
        return this.map.get(new HashableWrapper<IHashable>(hashable));
    }

    @Override
    public V remove(Object key) {
        if (key != null && !(key instanceof IHashable)) {
            return null;
        }
        IHashable hashable = (IHashable)key;
        return this.map.remove(new HashableWrapper<IHashable>(hashable));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        int numKeysToBeAdded = map.size();
        if (numKeysToBeAdded == 0) {
            return;
        }
        HashMap<HashableWrapper<IHashable>, V> tmp = new HashMap<HashableWrapper<IHashable>, V>(map.size());
        for (Map.Entry<K, V> e : map.entrySet()) {
            tmp.put(new HashableWrapper<IHashable>((IHashable)e.getKey()), e.getValue());
        }
        this.map.putAll(tmp);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<K> keySet() {
        Set<HashableWrapper<K>> keySet = this.map.keySet();
        if (keySet instanceof HashSet) {
            HashableSet hashableSet = new HashableSet();
            hashableSet.addAll((HashSet)this.map.keySet());
            return hashableSet;
        }
        return new HashableSet(new HashSet(this.map.keySet()));
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<HashableWrapper<K>, V>> wrappedEntrySet = this.map.entrySet();
        if (wrappedEntrySet instanceof HashSet) {
            return new HashableEntrySet((HashSet)wrappedEntrySet);
        }
        return new HashableEntrySet<K, V>(new HashSet<Map.Entry<HashableWrapper<K>, V>>(wrappedEntrySet));
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map other = (Map)object;
        if (other.size() != this.size()) {
            return false;
        }
        try {
            Iterator<Map.Entry<K, V>> iterator = this.entrySet().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return true;
                }
                Map.Entry<K, V> entry = iterator.next();
                IHashable key = (IHashable)entry.getKey();
                V value = entry.getValue();
                if (value == null) {
                    if (other.get(key) != null) return false;
                    if (other.containsKey(key)) continue;
                    return false;
                }
                if (!value.equals(other.get(key))) break;
            }
            return false;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public HashableMap<K, V> clone() {
        return new HashableMap<K, V>((HashMap)this.map.clone());
    }
}

