/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.number;

import java.math.BigDecimal;
import java.math.BigInteger;

public class ComparableNumber
extends Number
implements Comparable<ComparableNumber> {
    private static final long serialVersionUID = -6368954577382780447L;
    private final Number number;

    public ComparableNumber(Number number) {
        if (number instanceof ComparableNumber) {
            this.number = ((ComparableNumber)number).getNumber();
            return;
        }
        this.number = number;
    }

    @Override
    public int compareTo(ComparableNumber other) {
        if (this.number == null && (other == null || other.getNumber() == null)) {
            return 1;
        }
        if (this.number == null) {
            return -1;
        }
        if (other == null || other.getNumber() == null) {
            return 1;
        }
        Number value = other.getNumber();
        if (this.number instanceof BigDecimal && value instanceof BigDecimal) {
            return ((BigDecimal)this.number).compareTo((BigDecimal)value);
        }
        if (this.number instanceof BigInteger && value instanceof BigInteger) {
            return ((BigInteger)this.number).compareTo((BigInteger)value);
        }
        if (this.number instanceof Long && value instanceof Long) {
            return ((Long)this.number).compareTo((Long)value);
        }
        if (this.number instanceof Integer && value instanceof Integer) {
            return ((Integer)this.number).compareTo((Integer)value);
        }
        return Double.compare(this.number.doubleValue(), value.doubleValue());
    }

    public Number getNumber() {
        return this.number;
    }

    @Override
    public double doubleValue() {
        return this.number.doubleValue();
    }

    @Override
    public float floatValue() {
        return this.number.floatValue();
    }

    @Override
    public int intValue() {
        return this.number.intValue();
    }

    @Override
    public long longValue() {
        return this.number.longValue();
    }

    public String toString() {
        return this.number.toString();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof ComparableNumber) {
            return this.compareTo((ComparableNumber)other) == 0;
        }
        if (other instanceof Number) {
            return this.compareTo(new ComparableNumber((Number)other)) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.number.hashCode();
    }
}

