/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.object;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Arrays;

public class ObjectUtilities {
    public static final String NULL_STRING = "null";

    public static boolean equals(double org, double other) {
        return ObjectUtilities.equals((Object)org, (Object)other);
    }

    public static boolean equals(Object org, Object other) {
        if (org == other) {
            return true;
        }
        if (org == null) {
            return other == null;
        }
        boolean equals = org.equals(other);
        return equals;
    }

    public static boolean equals(byte[] is, byte[] bs) {
        if (is == bs) {
            return true;
        }
        if (is == null || bs == null || is.length != bs.length) {
            return false;
        }
        for (int i = 0; i < bs.length; ++i) {
            if (is[i] == bs[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(short[] is, short[] bs) {
        if (is == null && bs == null) {
            return true;
        }
        if (is == null || bs == null || is.length != bs.length) {
            return false;
        }
        for (int i = 0; i < bs.length; ++i) {
            if (is[i] == bs[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(int[] is, int[] bs) {
        if (is == null && bs == null) {
            return true;
        }
        if (is == null || bs == null || is.length != bs.length) {
            return false;
        }
        for (int i = 0; i < bs.length; ++i) {
            if (is[i] == bs[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(long[] is, long[] bs) {
        if (is == null && bs == null) {
            return true;
        }
        if (is == null || bs == null || is.length != bs.length) {
            return false;
        }
        for (int i = 0; i < bs.length; ++i) {
            if (is[i] == bs[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(float[] is, float[] bs) {
        if (is == null && bs == null) {
            return true;
        }
        if (is == null || bs == null || is.length != bs.length) {
            return false;
        }
        for (int i = 0; i < bs.length; ++i) {
            if (is[i] == bs[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(double[] ds, double[] bs) {
        if (ds == null && bs == null) {
            return true;
        }
        if (ds == null || bs == null || ds.length != bs.length) {
            return false;
        }
        for (int i = 0; i < bs.length; ++i) {
            if (Double.isNaN(ds[i]) && Double.isNaN(bs[i]) || ds[i] == bs[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(Object[] os, Object[] bs) {
        if (os == bs || os == null && bs == null) {
            return true;
        }
        if (os == null || bs == null || os.length != bs.length) {
            return false;
        }
        for (int i = 0; i < bs.length; ++i) {
            if (ObjectUtilities.equals(os[i], bs[i])) continue;
            return false;
        }
        return true;
    }

    public static int hashCode(int result, int prime, double value) {
        return ObjectUtilities.hashCode(result, prime, Double.doubleToLongBits(value));
    }

    public static int hashCode(int result, int prime, long value) {
        return prime * result + (int)(value ^ value >>> 32);
    }

    public static int hashCode(int result, int prime, Object object) {
        return prime * result + (object == null ? 0 : object.hashCode());
    }

    public static int hashCode(Object ... objects) {
        return Arrays.hashCode(objects);
    }

    public static boolean isToStringImplemented(Class<?> clazz) {
        try {
            Method method = clazz.getMethod("toString", new Class[0]);
            return !method.getDeclaringClass().equals(Object.class);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static String toString(Object object) {
        return ObjectUtilities.toString(object, null);
    }

    public static String toString(Object object, String nullValue) {
        if (object == null) {
            return nullValue;
        }
        if (Object.class.equals(object.getClass())) {
            return Integer.toHexString(object.hashCode());
        }
        if (ObjectUtilities.isToStringImplemented(object.getClass())) {
            return object.toString();
        }
        if (!object.getClass().getModule().isOpen(object.getClass().getPackageName(), ObjectUtilities.class.getModule())) {
            return object.toString();
        }
        if (System.getSecurityManager() == null) {
            Field[] fields = object.getClass().getDeclaredFields();
            return ObjectUtilities.toString(object, fields, nullValue);
        }
        return AccessController.doPrivileged(() -> {
            Field[] fields = object.getClass().getDeclaredFields();
            return ObjectUtilities.toString(object, fields, nullValue);
        });
    }

    private static String toString(Object object, Field[] fields, String nullValue) {
        int counter = 0;
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (Field field : fields) {
            if (field.isSynthetic()) continue;
            try {
                if (!field.canAccess(object)) {
                    field.setAccessible(true);
                }
                String string = ObjectUtilities.toString(field.get(object), nullValue);
                if (counter > 0) {
                    builder.append(", ");
                }
                builder.append(string);
                ++counter;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        builder.append("]");
        return builder.toString();
    }
}

