/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.optional;

import net.anwiba.commons.lang.functional.ISupplier;
import net.anwiba.commons.lang.optional.ILazy;
import net.anwiba.commons.lang.optional.IOptional;
import net.anwiba.commons.lang.optional.Optional;

public class Lazy<T, E extends Exception>
implements ILazy<T, E> {
    private final Class<E> exceptionClass;
    private final ISupplier<T, E> supplier;
    private IOptional<T, E> optional;

    Lazy(Class<E> exceptionClass, ISupplier<T, E> supplier) {
        this.exceptionClass = exceptionClass;
        this.supplier = supplier;
    }

    @Override
    public T get() throws E {
        this.check();
        return this.optional.get();
    }

    private synchronized void check() {
        if (this.optional == null) {
            this.optional = Optional.of(this.exceptionClass, null).or(this.supplier);
        }
    }

    @Override
    public IOptional<T, E> optional() {
        this.check();
        return this.optional;
    }

    public static <T> ILazy<T, RuntimeException> of(ISupplier<T, RuntimeException> supplier) {
        return Lazy.of(RuntimeException.class, supplier);
    }

    public static <T, E extends Exception> ILazy<T, E> of(Class<E> exceptionClass, ISupplier<T, E> supplier) {
        return new Lazy<T, E>(exceptionClass, supplier);
    }

    public static <T, E extends Exception> ILazy<T, E> narrow(ILazy<? extends T, E> lazy) {
        return lazy;
    }
}

