/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.tree;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.anwiba.commons.lang.object.ObjectUtilities;
import net.anwiba.commons.lang.tree.ITreeItem;
import net.anwiba.commons.lang.tree.ITreeItemChooser;
import net.anwiba.commons.lang.tree.distance.IObjectDistanceCalculator;

public final class TreeItemChooser<K, V>
implements ITreeItemChooser<K, V> {
    private final IObjectDistanceCalculator<K> distanceCalculator;
    private final Map<ObjectPair<K, K>, Double> distances = new HashMap<ObjectPair<K, K>, Double>();
    private final Map<K, Set<ObjectPair<K, K>>> distanceKeys = new HashMap<K, Set<ObjectPair<K, K>>>();

    public TreeItemChooser(IObjectDistanceCalculator<K> distanceCalculator) {
        this.distanceCalculator = distanceCalculator;
    }

    @Override
    public K choose(Comparator<K> comparator, ITreeItem<K, V> item, K key, V element) {
        Object itemKey = item.getKey();
        double distancePrecursorSuccessor = this.calculate(item.getPrevious().getKey(), item.getNext().getKey());
        if (Double.isNaN(distancePrecursorSuccessor)) {
            return itemKey;
        }
        double distancePrecursorItem = this.calculate(item.getPrevious().getKey(), itemKey);
        if (Double.isNaN(distancePrecursorItem)) {
            return key;
        }
        double distancePrecursorOther = this.calculate(item.getPrevious().getKey(), key);
        if (Double.isNaN(distancePrecursorOther)) {
            return itemKey;
        }
        if (this.isOtherMoreCentral(distancePrecursorSuccessor, distancePrecursorItem, distancePrecursorOther)) {
            return key;
        }
        return itemKey;
    }

    private boolean isOtherMoreCentral(double distance, double distanceToItem, double distanceToOther) {
        return Math.abs(distance / 2.0 - distanceToOther) < Math.abs(distance / 2.0 - distanceToItem);
    }

    private double calculate(K key, K other) {
        ObjectPair<K, K> distanceKey = new ObjectPair<K, K>(key, other);
        if (this.distances.containsKey(distanceKey)) {
            return this.distances.get(distanceKey);
        }
        double distance = this.distanceCalculator.calculate(key, other);
        this.cache(distanceKey, distance);
        return distance;
    }

    private void cache(ObjectPair<K, K> distanceKey, double distance) {
        this.distances.put(distanceKey, distance);
        this.cache(distanceKey.getFirstObject(), distanceKey);
        this.cache(distanceKey.getSecondObject(), distanceKey);
    }

    private void cache(K key, ObjectPair<K, K> distanceKey) {
        if (!this.distanceKeys.containsKey(key)) {
            this.distanceKeys.put(key, new HashSet());
        }
        this.distanceKeys.get(key).add(distanceKey);
    }

    @Override
    public void removed(K key) {
        if (!this.distanceKeys.containsKey(key)) {
            return;
        }
        Set<ObjectPair<K, K>> set = this.distanceKeys.get(key);
        for (ObjectPair<K, K> distanceKey : set) {
            this.distances.remove(distanceKey);
        }
        this.distanceKeys.remove(key);
    }

    public class ObjectPair<T, U> {
        private final int hashCode;
        private final T firstObject;
        private final U secondObject;

        public ObjectPair(T firstObject, U secondObject) {
            this.firstObject = firstObject;
            this.secondObject = secondObject;
            this.hashCode = this.calculate();
        }

        public int calculate() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.firstObject == null ? 0 : this.firstObject.hashCode());
            result = 31 * result + (this.secondObject == null ? 0 : this.secondObject.hashCode());
            return result;
        }

        public final T getFirstObject() {
            return this.firstObject;
        }

        public final U getSecondObject() {
            return this.secondObject;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ObjectPair)) {
                return false;
            }
            ObjectPair other = (ObjectPair)obj;
            return ObjectUtilities.equals(this.firstObject, other.firstObject) && ObjectUtilities.equals(this.secondObject, other.secondObject);
        }

        public final int hashCode() {
            return this.hashCode;
        }
    }
}

