/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.exception;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.anwiba.commons.lang.exception.IAdditionalThrowableIterable;
import net.anwiba.commons.lang.exception.IThrowableToStringConverter;
import net.anwiba.commons.lang.exception.UnreachableCodeReachedException;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.lang.optional.IOptional;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.lang.primitive.BooleanContainer;
import net.anwiba.commons.lang.stream.Streams;

public class Throwables {
    public static final List<IThrowableToStringConverter> toStringConverters = new ArrayList<IThrowableToStringConverter>();
    public static final List<IAdditionalThrowableIterable> additionalThrowableIterables = new ArrayList<IAdditionalThrowableIterable>();

    public static void register(IThrowableToStringConverter toStringConverter) {
        toStringConverters.add(toStringConverter);
    }

    public static <E extends Throwable> void register(final Class<E> throwableClass, final Function<Throwable, String> toStringConverter) {
        toStringConverters.add(new IThrowableToStringConverter(){

            @Override
            public boolean isApplicable(Throwable throwable) {
                return throwableClass.isInstance(throwable);
            }

            @Override
            public String toString(Throwable throwable) {
                return (String)toStringConverter.apply(throwable);
            }
        });
    }

    public static void register(IAdditionalThrowableIterable additionalThrowableIterable) {
        additionalThrowableIterables.add(additionalThrowableIterable);
    }

    public static void walk(Throwable throwable, ThrowableVisitor visitor) {
        Throwables.walkThrowable(Objects.requireNonNull(throwable), Objects.requireNonNull(visitor), new LinkedHashSet<Throwable>());
    }

    private static ThrowableVisitorResult walkThrowable(Throwable throwable, ThrowableVisitor visitor, Set<Throwable> visited) {
        Throwable cause;
        if (visited.contains(throwable)) {
            return ThrowableVisitorResult.CONTINUE;
        }
        visited.add(throwable);
        visitor.visitThrowable(throwable);
        switch (visitor.preVisitCause(throwable)) {
            case CONTINUE: {
                if (!visitor.visitThrowable(throwable).terminated()) break;
                return ThrowableVisitorResult.TERMINATE;
            }
            case TERMINATE: {
                return ThrowableVisitorResult.TERMINATE;
            }
        }
        IOptional<IAdditionalThrowableIterable, RuntimeException> optionalIterable = Streams.of(additionalThrowableIterables).first(i -> i.isApplicable(throwable));
        if (optionalIterable.isAccepted()) {
            for (Throwable additionalThrowable : optionalIterable.get().iterable(throwable)) {
                if (visited.contains(additionalThrowable)) continue;
                switch (visitor.preVisitSuppressed(throwable)) {
                    case CONTINUE: {
                        if (!Throwables.walkThrowable(additionalThrowable, visitor, visited).terminated()) break;
                        return ThrowableVisitorResult.TERMINATE;
                    }
                    case SKIP: {
                        break;
                    }
                    case TERMINATE: {
                        return ThrowableVisitorResult.TERMINATE;
                    }
                }
            }
        }
        if ((cause = throwable.getCause()) != null && !visited.contains(cause)) {
            switch (visitor.preVisitCause(throwable)) {
                case CONTINUE: {
                    if (!Throwables.walkThrowable(cause, visitor, visited).terminated()) break;
                    return ThrowableVisitorResult.TERMINATE;
                }
                case TERMINATE: {
                    return ThrowableVisitorResult.TERMINATE;
                }
            }
        }
        block19: for (Throwable suppressed : throwable.getSuppressed()) {
            if (visited.contains(suppressed)) continue;
            switch (visitor.preVisitSuppressed(throwable)) {
                case CONTINUE: {
                    if (!Throwables.walkThrowable(suppressed, visitor, visited).terminated()) continue block19;
                    return ThrowableVisitorResult.TERMINATE;
                }
                case SKIP: {
                    continue block19;
                }
                case TERMINATE: {
                    return ThrowableVisitorResult.TERMINATE;
                }
            }
        }
        return ThrowableVisitorResult.CONTINUE;
    }

    public static boolean isApplicable(Throwable throwable) {
        return Throwables.hasIterator(throwable) || Throwables.hasConverter(throwable);
    }

    public static boolean hasIterator(Throwable throwable) {
        if (throwable == null || additionalThrowableIterables.isEmpty()) {
            return false;
        }
        BooleanContainer isApplicable = new BooleanContainer(false);
        Throwables.walk(throwable, throwable1 -> {
            if (Streams.of(additionalThrowableIterables).first(resolver -> resolver.isApplicable(throwable1)).isAccepted()) {
                isApplicable.set(true);
                return ThrowableVisitorResult.TERMINATE;
            }
            return ThrowableVisitorResult.CONTINUE;
        });
        return isApplicable.isTrue();
    }

    public static boolean hasConverter(Throwable throwable) {
        if (throwable == null || toStringConverters.isEmpty()) {
            return false;
        }
        BooleanContainer isApplicable = new BooleanContainer(false);
        Throwables.walk(throwable, throwable1 -> {
            if (Streams.of(toStringConverters).first(resolver -> resolver.isApplicable(throwable1)).isAccepted()) {
                isApplicable.set(true);
                return ThrowableVisitorResult.TERMINATE;
            }
            return ThrowableVisitorResult.CONTINUE;
        });
        return isApplicable.isTrue();
    }

    public static String toString(Throwable throwable) {
        return Throwables.toString(throwable, toStringConverters, t -> {
            if (t.getCause() != null && !Objects.equals(t, t.getCause()) && Objects.equals(t.getMessage(), t.getCause().getMessage())) {
                return null;
            }
            return t.getMessage();
        });
    }

    public static String toString(Throwable throwable, List<IThrowableToStringConverter> toStringConverters, IConverter<Throwable, String, RuntimeException> defaultToStringConverter) {
        return Throwables.toString(throwable, t -> Streams.of(toStringConverters).first(resolver -> resolver.isApplicable((Throwable)t)).convert(resolver -> resolver.toString((Throwable)t)).getOr(() -> (String)defaultToStringConverter.convert((Throwable)t)));
    }

    public static String toString(Throwable throwable, final IConverter<Throwable, String, RuntimeException> toStringConverter) {
        final LinkedHashSet messages = new LinkedHashSet();
        Throwables.walk(throwable, new ThrowableVisitor(){

            @Override
            public ThrowableVisitorResult visitThrowable(Throwable throwable) {
                Optional.of((String)toStringConverter.convert(throwable)).consume(m -> messages.add(m));
                return ThrowableVisitorResult.CONTINUE;
            }
        });
        return String.join((CharSequence)"\n", messages);
    }

    public static String toStackTraceString(Throwable throwable) {
        String string;
        Objects.requireNonNull(throwable);
        StringWriter stringWriter = new StringWriter();
        try {
            throwable.printStackTrace(new PrintWriter(stringWriter));
            string = stringWriter.getBuffer().toString();
        }
        catch (Throwable throwable2) {
            try {
                try {
                    stringWriter.close();
                }
                catch (Throwable throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
            catch (IOException exception) {
                throw new UnreachableCodeReachedException(exception);
            }
        }
        stringWriter.close();
        return string;
    }

    public static interface ThrowableVisitor {
        default public ThrowableVisitorResult preVisitCause(Throwable throwable) {
            return ThrowableVisitorResult.CONTINUE;
        }

        default public SuppressedThrowableVisitorResult preVisitSuppressed(Throwable throwable) {
            return SuppressedThrowableVisitorResult.CONTINUE;
        }

        public ThrowableVisitorResult visitThrowable(Throwable var1);
    }

    public static enum ThrowableVisitorResult {
        CONTINUE,
        TERMINATE;


        boolean terminated() {
            return this == TERMINATE;
        }
    }

    public static enum SuppressedThrowableVisitorResult {
        CONTINUE,
        SKIP,
        TERMINATE;

    }
}

