/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.random;

import java.awt.Color;
import java.time.LocalDate;
import java.util.Random;
import net.anwiba.commons.lang.random.IIsNullDecider;

public final class RandomObjectGenerator {
    private final Random random;
    private final IIsNullDecider isNullDecider;
    private final int maximumStringLength;

    public RandomObjectGenerator(long seed, IIsNullDecider isNullDecider) {
        this(seed, isNullDecider, 32);
    }

    public RandomObjectGenerator(long seed, IIsNullDecider isNullDecider, int maximumStringLength) {
        this.isNullDecider = isNullDecider;
        this.maximumStringLength = maximumStringLength;
        this.random = new Random(seed);
    }

    public String generateString() {
        if (this.isNullDecider.isNull()) {
            return null;
        }
        int length = 0;
        while ((length = this.random.nextInt(this.maximumStringLength)) == 0) {
        }
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            builder.append(this.generateCharacter());
        }
        return builder.toString();
    }

    public char generateCharacter() {
        int digit = this.random.nextInt(36);
        char character = Character.forDigit(digit, 36);
        return character;
    }

    public Double generateDouble() {
        if (this.isNullDecider.isNull()) {
            return null;
        }
        return this.random.nextDouble();
    }

    public Boolean generateBoolean() {
        if (this.isNullDecider.isNull()) {
            return null;
        }
        return this.random.nextBoolean();
    }

    public Integer generateInteger() {
        if (this.isNullDecider.isNull()) {
            return null;
        }
        return this.random.nextInt();
    }

    public Integer generateInteger(int maximum) {
        if (this.isNullDecider.isNull()) {
            return null;
        }
        return this.random.nextInt(maximum);
    }

    public LocalDate generateLocalDate() {
        return LocalDate.of(1920 + this.random.nextInt(100), 1 + this.random.nextInt(11), 1 + this.random.nextInt(28));
    }

    public Color generateColor(boolean hasAlpha) {
        if (hasAlpha) {
            return new Color(this.generateInteger(255), this.generateInteger(255), this.generateInteger(255), this.generateInteger(255));
        }
        return new Color(this.generateInteger(255), this.generateInteger(255), this.generateInteger(255));
    }
}

