/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.stream;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.stream.Stream;
import net.anwiba.commons.lang.collection.IObjectList;
import net.anwiba.commons.lang.functional.IAcceptor;
import net.anwiba.commons.lang.functional.IAggregator;
import net.anwiba.commons.lang.functional.IAssimilator;
import net.anwiba.commons.lang.functional.ICloseable;
import net.anwiba.commons.lang.functional.IConsumer;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.lang.functional.IFactory;
import net.anwiba.commons.lang.functional.IIntAssimilator;
import net.anwiba.commons.lang.functional.ISupplier;
import net.anwiba.commons.lang.optional.IOptional;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.lang.stream.IStream;
import net.anwiba.commons.lang.stream.Streams;

public class FailedStream<T, E extends Exception>
implements IStream<T, E> {
    private final Class<E> exceptionClass;
    private final E cause;
    private final ICloseable<E> closeable;

    FailedStream(Class<E> exceptionClass, E cause, ICloseable<E> closeable) {
        this.closeable = closeable;
        this.exceptionClass = Objects.requireNonNull(exceptionClass);
        this.cause = (Exception)Objects.requireNonNull(cause);
    }

    @Override
    public IStream<T, E> execute() {
        return this;
    }

    @Override
    public IStream<T, E> distinct() {
        return this;
    }

    @Override
    public IStream<T, E> filter(IAcceptor<T> funtion) {
        return this;
    }

    @Override
    public <O> IStream<O, E> convert(IConverter<T, O, E> funtion) {
        return FailedStream.stream(this.exceptionClass, this.cause, this.closeable);
    }

    @Override
    public <O> IStream<O, E> flat(IConverter<T, Iterable<O>, E> funtion) {
        return FailedStream.stream(this.exceptionClass, this.cause, this.closeable);
    }

    @Override
    public <O> IStream<O, E> convert(IAggregator<Integer, T, O, E> aggregator) {
        return FailedStream.stream(this.exceptionClass, this.cause, this.closeable);
    }

    @Override
    public IStream<T, E> failed(ISupplier<Iterable<T>, E> supplier) {
        try {
            return Streams.of(this.exceptionClass, supplier.supply());
        }
        catch (Exception exception) {
            return FailedStream.stream(this.exceptionClass, exception, () -> {});
        }
    }

    @Override
    public IStream<T, E> foreach(IConsumer<T, E> consumer) {
        return this;
    }

    @Override
    public IStream<T, E> foreach(int initial, IIntAssimilator<T, E> assimilator) {
        return this;
    }

    @Override
    public IStream<T, E> foreach(IAssimilator<Integer, T, E> assimilator) {
        return this;
    }

    @Override
    public IStream<T, E> notNull() {
        return this;
    }

    @Override
    public IStream<T, E> revert() {
        return this;
    }

    @Override
    public <O> IStream<O, E> instanceOf(Class<O> clazz) {
        return FailedStream.stream(this.exceptionClass, this.cause, this.closeable);
    }

    @Override
    public <O> O[] asArray(IntFunction<O[]> function) throws E {
        throw this.cause;
    }

    @Override
    public Iterable<T> toIterable() throws E {
        throw this.cause;
    }

    @Override
    public <O> Collection<O> asCollection() throws E {
        throw this.cause;
    }

    @Override
    public <O> List<O> asList() throws E {
        throw this.cause;
    }

    @Override
    public <O> Set<O> asSet() throws E {
        throw this.cause;
    }

    @Override
    public <K, V> Map<K, V> asMap(IFactory<T, K, E> keyFactrory, IFactory<T, V, E> valueFactrory) throws E {
        throw this.cause;
    }

    @Override
    public <O> IObjectList<O> asObjectList() throws E {
        throw this.cause;
    }

    @Override
    public IOptional<T, E> first() {
        return Optional.failed(this.exceptionClass, this.cause);
    }

    @Override
    public IOptional<T, E> first(IAcceptor<T> acceptor) {
        return Optional.failed(this.exceptionClass, this.cause);
    }

    @Override
    public <O> IOptional<O, E> aggregate(O inital, IAggregator<O, T, O, E> aggregator) {
        return Optional.failed(this.exceptionClass, this.cause);
    }

    private static <T, E extends Exception> IStream<T, E> stream(Class<E> exceptionClass, Exception exception, ICloseable<E> closeable) {
        if (exceptionClass.isInstance(exception)) {
            return new FailedStream<T, Exception>(exceptionClass, exception, closeable);
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new RuntimeException(exception.getMessage(), exception);
    }

    @Override
    public boolean foundAny() throws E {
        throw this.cause;
    }

    @Override
    public void throwIfFailed() throws E {
        throw this.cause;
    }

    @Override
    public boolean isEmpty() throws E {
        throw this.cause;
    }

    @Override
    public boolean isSuccessful() {
        return false;
    }

    @Override
    public boolean foundAny(IAcceptor<T> acceptor) throws E {
        throw this.cause;
    }

    @Override
    public <O> Stream<O> asStream() throws E {
        throw this.cause;
    }

    @Override
    public Stream<T> toStream() throws E {
        throw this.cause;
    }
}

