/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.tree.distance;

import net.anwiba.commons.lang.tree.distance.IObjectDistanceCalculator;

public final class LevenshteinStringDistanceCalculator
implements IObjectDistanceCalculator<String> {
    @Override
    public double calculate(String string, String other) {
        if (string == null || other == null) {
            throw new IllegalArgumentException();
        }
        int stringLength = string.length();
        int otherLength = other.length();
        if (stringLength == 0) {
            return otherLength;
        }
        if (otherLength == 0) {
            return stringLength;
        }
        int[] horizontalPreviousCosts = new int[stringLength + 1];
        int[] horizontalCosts = new int[stringLength + 1];
        for (int i = 0; i <= stringLength; ++i) {
            horizontalPreviousCosts[i] = i;
        }
        for (int j = 1; j <= otherLength; ++j) {
            char c = other.charAt(j - 1);
            horizontalCosts[0] = j;
            for (int i = 1; i <= stringLength; ++i) {
                int cost = string.charAt(i - 1) == c ? 0 : 1;
                horizontalCosts[i] = Math.min(Math.min(horizontalCosts[i - 1] + 1, horizontalPreviousCosts[i] + 1), horizontalPreviousCosts[i - 1] + cost);
            }
            int[] swappingArray = horizontalPreviousCosts;
            horizontalPreviousCosts = horizontalCosts;
            horizontalCosts = swappingArray;
        }
        return horizontalPreviousCosts[stringLength];
    }
}

