/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.counter;

import net.anwiba.commons.lang.counter.IIntCounter;

public class IntCounter
implements IIntCounter {
    private int value;
    private final int maxValue;
    private final int startValue;

    public IntCounter(int value) {
        this(value, Integer.MAX_VALUE);
    }

    public IntCounter(int startValue, int maxValue) {
        this.value = startValue;
        this.startValue = startValue;
        this.maxValue = maxValue;
    }

    @Override
    public synchronized void reset() {
        this.value = this.startValue;
    }

    @Override
    public synchronized int value() {
        return this.value;
    }

    @Override
    public synchronized int next() {
        if (this.value < this.maxValue) {
            return ++this.value;
        }
        this.value = this.startValue;
        return this.value;
    }

    @Override
    public void increment() {
        this.next();
    }

    @Override
    public void decrement() {
        this.previous();
    }

    @Override
    public synchronized int previous() {
        if (this.value > this.startValue) {
            return --this.value;
        }
        this.value = this.maxValue;
        return this.value;
    }

    public synchronized long minimum() {
        this.value = this.startValue;
        return this.value;
    }

    public synchronized long maximum() {
        this.value = this.maxValue;
        return this.value;
    }
}

