/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.exception;

import java.util.List;
import java.util.function.Function;
import net.anwiba.commons.lang.exception.ThrowableConverterResult;
import net.anwiba.commons.lang.optional.IOptional;
import net.anwiba.commons.lang.optional.Optional;

public interface IThrowableToStringConverter {
    default public boolean isApplicable(Throwable throwable) {
        return this.getThrowableClass().convert((T throwableClass) -> throwableClass.isInstance(throwable)).getOr(() -> Boolean.FALSE);
    }

    public ThrowableConverterResult convert(Throwable var1);

    default public IOptional<Class<? extends Throwable>, RuntimeException> getThrowableClass() {
        return Optional.empty();
    }

    public static <E extends Throwable> IThrowableToStringConverter of(final Class<E> throwableClass, final Function<Throwable, String> toStringConverter) {
        return new IThrowableToStringConverter(){

            @Override
            public IOptional<Class<? extends Throwable>, RuntimeException> getThrowableClass() {
                return Optional.of(throwableClass);
            }

            @Override
            public ThrowableConverterResult convert(Throwable throwable) {
                return ThrowableConverterResult.of((String)toStringConverter.apply(throwable));
            }
        };
    }

    default public void addTo(List<String> messages, String title, int value) {
        this.addTo(messages, title, String.valueOf(value));
    }

    default public void addTo(List<String> messages, String title, boolean value) {
        this.addTo(messages, title, String.valueOf(value));
    }

    default public void addTo(List<String> messages, String title, String value) {
        if (value == null || value.isBlank()) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(title).append("=").append(value);
        messages.add(builder.toString());
    }
}

