/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.exception;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.anwiba.commons.lang.exception.IAdditionalThrowableIterable;
import net.anwiba.commons.lang.exception.IThrowableMessageExtractor;
import net.anwiba.commons.lang.exception.IThrowableToStringConverter;
import net.anwiba.commons.lang.exception.IThrowableVisitor;
import net.anwiba.commons.lang.exception.ThrowableConverterResult;
import net.anwiba.commons.lang.exception.ThrowableVisitResult;
import net.anwiba.commons.lang.exception.ThrowableWalker;
import net.anwiba.commons.lang.exception.WrappedException;
import net.anwiba.commons.lang.functional.IAcceptor;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.lang.registry.HierarchicalClassKeyRegistry;
import net.anwiba.commons.lang.stream.Streams;

public class ThrowableMessageExtractor
implements IThrowableMessageExtractor {
    private final Function<Throwable, IThrowableToStringConverter> toStringConverterSelector;
    private final Collection<IAdditionalThrowableIterable> additionalThrowableIterables;

    public static ThrowableMessageExtractor of(Collection<IThrowableToStringConverter> toStringConverters, Collection<IAdditionalThrowableIterable> additionalThrowableIterables) {
        Collection<IThrowableToStringConverter> converters = Collections.unmodifiableCollection(toStringConverters);
        HierarchicalClassKeyRegistry toStringConverterRegistry = new HierarchicalClassKeyRegistry();
        Streams.of(toStringConverters).filter(converter -> converter.getThrowableClass().isAccepted()).forEach(converter -> toStringConverterRegistry.add(converter.getThrowableClass().get(), converter));
        Function<Throwable, IThrowableToStringConverter> toStringConverterSelector = throwable -> {
            IThrowableToStringConverter converter = (IThrowableToStringConverter)toStringConverterRegistry.get(throwable.getClass());
            return converter != null ? converter : Streams.of(converters).first(c -> c.isApplicable((Throwable)throwable)).get();
        };
        return new ThrowableMessageExtractor(toStringConverterSelector, additionalThrowableIterables);
    }

    public ThrowableMessageExtractor(Function<Throwable, IThrowableToStringConverter> toStringConverterSelector, Collection<IAdditionalThrowableIterable> additionalThrowableIterables) {
        this.toStringConverterSelector = toStringConverterSelector;
        this.additionalThrowableIterables = Collections.unmodifiableCollection(additionalThrowableIterables);
    }

    @Override
    public String extract(Throwable throwable) {
        Throwable throwable2;
        if (throwable instanceof WrappedException) {
            WrappedException wrapped = (WrappedException)throwable;
            throwable2 = wrapped.getCause();
        } else {
            throwable2 = throwable;
        }
        return this.extract(throwable2, this.toStringConverterSelector, t -> t.getCause() != null && !Objects.equals(t, t.getCause()) && this.equalMessages((Throwable)t, t.getCause()) ? null : ThrowableConverterResult.of(t.getMessage() == null ? null : t.getMessage().trim()));
    }

    private String extract(Throwable throwable, Function<Throwable, IThrowableToStringConverter> converterSelector, IConverter<Throwable, ThrowableConverterResult, RuntimeException> defaultConverter) {
        return this.extract(throwable, t -> Optional.of((IThrowableToStringConverter)converterSelector.apply((Throwable)t)).convert(converter -> converter.convert((Throwable)t)).getOr(() -> (ThrowableConverterResult)defaultConverter.convert((Throwable)t)));
    }

    private String extract(Throwable throwable, IConverter<Throwable, ThrowableConverterResult, RuntimeException> toStringConverter) {
        LinkedHashSet<String> messages = new LinkedHashSet<String>();
        HashSet<Throwable> visited = new HashSet<Throwable>();
        ThrowableWalker.of(this.additionalThrowableIterables, new ThrowableVisitor(messages, visited, toStringConverter)).walk(throwable);
        return messages.isEmpty() ? (throwable == null ? null : throwable.toString()) : String.join((CharSequence)"\n", messages);
    }

    private boolean equalMessages(Throwable throwable, Throwable cause) {
        String message = throwable.getMessage() == null ? null : throwable.getMessage().trim();
        String causeMessage = cause.getMessage() == null ? null : cause.getMessage().trim();
        String prefix = cause.getClass().getName() + ": ";
        if (message != null && message.startsWith(prefix)) {
            return Objects.equals(message.substring(prefix.length()), causeMessage);
        }
        return Objects.equals(message, causeMessage);
    }

    private final class ThrowableVisitor
    implements IThrowableVisitor {
        private final Set<String> messages;
        private final Set<Throwable> visited;
        private final IConverter<Throwable, ThrowableConverterResult, RuntimeException> toStringConverter;

        private ThrowableVisitor(Set<String> messages, Set<Throwable> visited, IConverter<Throwable, ThrowableConverterResult, RuntimeException> toStringConverter) {
            this.messages = messages;
            this.visited = visited;
            this.toStringConverter = toStringConverter;
        }

        @Override
        public ThrowableVisitResult preVisit(Throwable throwable) {
            return IThrowableVisitor.preVisit(this.visited, throwable);
        }

        @Override
        public ThrowableVisitResult visit(Throwable throwable) {
            return Optional.of(throwable).convert(this.toStringConverter).consume(result -> Optional.of(result).convert(ThrowableConverterResult::string).accept(IAcceptor.not(String::isBlank)).consume(this::add)).convert(ThrowableConverterResult::result).getOr(() -> ThrowableVisitResult.CONTINUE);
        }

        private void add(String string) {
            if (this.messages.contains(string)) {
                return;
            }
            if (!this.messages.isEmpty() && Streams.of(this.messages).filter(message -> message.contains(string)).foundAny()) {
                return;
            }
            Streams.of(this.messages).filter(string::contains).foreach(this.messages::remove);
            this.messages.add(string);
        }
    }
}

