/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.exception;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.StreamSupport;
import net.anwiba.commons.lang.exception.IAdditionalThrowableIterable;
import net.anwiba.commons.lang.exception.IThrowableVisitor;
import net.anwiba.commons.lang.exception.ThrowableVisitResult;

public class ThrowableWalker {
    private final List<IAdditionalThrowableIterable> additionalThrowableIterables = new ArrayList<IAdditionalThrowableIterable>();
    private final IThrowableVisitor visitor;

    public static ThrowableWalker of(Collection<IAdditionalThrowableIterable> additionalThrowableIterables, IThrowableVisitor visitor) {
        return new ThrowableWalker(additionalThrowableIterables, visitor);
    }

    private ThrowableWalker(Collection<IAdditionalThrowableIterable> additionalThrowableIterables, IThrowableVisitor visitor) {
        this.additionalThrowableIterables.addAll(Objects.requireNonNull(additionalThrowableIterables));
        this.visitor = Objects.requireNonNull(visitor);
    }

    public void walk(Throwable throwable) {
        this.walkTo(throwable);
    }

    private ThrowableVisitResult walkTo(Throwable throwable) {
        Optional<ThrowableVisitResult> preVisitResult = this.getReturnResult(this.visitor.preVisit(throwable));
        if (preVisitResult.isPresent()) {
            return preVisitResult.get();
        }
        Optional<ThrowableVisitResult> result = this.getReturnResult(this.visitor.visit(throwable));
        if (result.isPresent()) {
            return result.get();
        }
        for (Throwable child : this.createContainingThrowableIterable(throwable)) {
            Optional<ThrowableVisitResult> walkToResult = this.getReturnResult(this.walkTo(child));
            if (!walkToResult.isPresent()) continue;
            return walkToResult.get();
        }
        return ThrowableVisitResult.CONTINUE;
    }

    private Optional<ThrowableVisitResult> getReturnResult(ThrowableVisitResult visitResult) {
        if (Objects.equals((Object)visitResult, (Object)ThrowableVisitResult.TERMINATE)) {
            return Optional.of(ThrowableVisitResult.TERMINATE);
        }
        if (Objects.equals((Object)visitResult, (Object)ThrowableVisitResult.SKIP)) {
            return Optional.of(ThrowableVisitResult.CONTINUE);
        }
        return Optional.empty();
    }

    private Iterable<Throwable> createContainingThrowableIterable(Throwable throwable) {
        LinkedList<Throwable> throwables = new LinkedList<Throwable>();
        this.additionalThrowableIterables.stream().filter(i -> i.isApplicable(throwable)).flatMap(i -> StreamSupport.stream(i.iterable(throwable).spliterator(), false)).filter(Objects::nonNull).forEach(throwables::add);
        Optional.ofNullable(throwable.getCause()).ifPresent(throwables::add);
        Arrays.stream(throwable.getSuppressed()).filter(Objects::nonNull).forEach(throwables::add);
        return throwables;
    }
}

