/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.exception;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import net.anwiba.commons.lang.exception.IThrowableMessageExtractor;
import net.anwiba.commons.lang.exception.UnreachableCodeReachedException;
import net.anwiba.commons.lang.optional.Optional;

public class Throwables {
    private static IThrowableMessageExtractor extractor = new IThrowableMessageExtractor(){

        @Override
        public String extract(Throwable throwable) {
            return throwable.getMessage();
        }
    };

    public static void setThrowableMessageExtractor(IThrowableMessageExtractor extractor) {
        Throwables.extractor = extractor;
    }

    private Throwables() {
    }

    public static String getExtendedMessage(Throwable throwable) {
        return extractor.extract(throwable);
    }

    public static String toStackTraceString(Throwable throwable) {
        return Optional.of(throwable).convert(t -> {
            String string;
            StringWriter stringWriter = new StringWriter();
            try {
                throwable.printStackTrace(new PrintWriter(stringWriter));
                string = stringWriter.getBuffer().toString();
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        stringWriter.close();
                    }
                    catch (Throwable throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
                catch (IOException exception) {
                    throw new UnreachableCodeReachedException(exception);
                }
            }
            stringWriter.close();
            return string;
        }).get();
    }

    public static <E extends Throwable> Function<Throwable, E> toException(Class<E> throwableClass) {
        try {
            Constructor constructor = throwableClass.getConstructor(String.class, Throwable.class);
            return t -> {
                try {
                    return (Throwable)constructor.newInstance(t.getMessage(), t);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException exception) {
                    throw new UnsupportedOperationException(exception.getMessage(), exception);
                }
            };
        }
        catch (NoSuchMethodException | SecurityException exception) {
            throw new UnsupportedOperationException(exception.getMessage(), exception);
        }
    }

    public static <E extends Throwable> E concat(Function<Throwable, E> toException, Throwable ... throwables) {
        return Throwables.concat(toException, Arrays.asList(throwables));
    }

    public static <E extends Throwable> E concat(Function<Throwable, E> toException, List<Throwable> throwables) {
        Throwable first = null;
        for (Throwable throwable : throwables) {
            if (throwable == null) continue;
            if (first == null) {
                first = (Throwable)toException.apply(throwable);
                continue;
            }
            first.addSuppressed(throwable);
        }
        return (E)first;
    }

    public static <E extends Throwable> void throwIfNotEmpty(Function<Throwable, E> toException, List<Throwable> throwables) throws E {
        Throwables.throwIfNotNull(toException, Throwables.concat(toException, throwables));
    }

    public static <E extends Throwable> void throwIfNotNull(Function<Throwable, E> toException, Throwable throwable) throws E {
        if (throwable == null) {
            return;
        }
        throw (Throwable)toException.apply(throwable);
    }
}

