/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.exception;

import net.anwiba.commons.lang.functional.ISupplier;
import net.anwiba.commons.lang.optional.Optional;

public class WrappedException
extends RuntimeException {
    private static final long serialVersionUID = 1L;

    public WrappedException() {
    }

    public WrappedException(Throwable throwable) {
        super(throwable);
    }

    public <E extends Exception> WrappedException ifThrowAs(Class<E> clazz) throws E {
        Optional.of(clazz, this.getCause()).instanceOf(clazz).consume(e -> {
            throw e;
        });
        return this;
    }

    public static WrappedException of(Throwable throwable) {
        throw new WrappedException(throwable);
    }

    public static <T> T wrap(ISupplier<T, Exception> supplier) throws WrappedException {
        try {
            return supplier.supply();
        }
        catch (Exception exception) {
            throw WrappedException.of(exception);
        }
    }

    public void throwAsRuntime() throws RuntimeException {
        Throwable cause = this.getCause();
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        if (cause == null) {
            throw new RuntimeException();
        }
        throw new RuntimeException(cause.getMessage(), cause);
    }

    public RuntimeException getAsRuntime() {
        Throwable cause = this.getCause();
        if (cause instanceof RuntimeException) {
            return (RuntimeException)cause;
        }
        if (cause == null) {
            return new RuntimeException();
        }
        return new RuntimeException(cause.getMessage(), cause);
    }
}

