/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.functional;

import java.util.Objects;

@FunctionalInterface
public interface IAcceptor<T> {
    public boolean accept(T var1);

    public static <T> IAcceptor<T> not(IAcceptor<T> acceptor) {
        Objects.requireNonNull(acceptor);
        return acceptor.not();
    }

    public static <T> IAcceptor<T> accept() {
        return t -> true;
    }

    default public IAcceptor<T> not() {
        return t -> !this.accept(t);
    }

    default public IAcceptor<T> and(IAcceptor<? super T> other) {
        Objects.requireNonNull(other);
        return t -> this.accept(t) && other.accept(t);
    }

    default public IAcceptor<T> or(IAcceptor<? super T> other) {
        Objects.requireNonNull(other);
        return t -> this.accept(t) || other.accept(t);
    }
}

