/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.functional;

import java.util.Objects;

@FunctionalInterface
public interface IApplicable<T> {
    public boolean isApplicable(T var1);

    public static <T> IApplicable<T> not(IApplicable<T> applicable) {
        Objects.requireNonNull(applicable);
        return applicable.not();
    }

    default public IApplicable<T> not() {
        return t -> !this.isApplicable(t);
    }

    default public IApplicable<T> and(IApplicable<? super T> other) {
        Objects.requireNonNull(other);
        return t -> this.isApplicable(t) && other.isApplicable(t);
    }

    default public IApplicable<T> or(IApplicable<? super T> other) {
        Objects.requireNonNull(other);
        return t -> this.isApplicable(t) || other.isApplicable(t);
    }
}

