/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.functional;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.anwiba.commons.lang.functional.ICloseable;
import net.anwiba.commons.lang.stream.IStream;
import net.anwiba.commons.lang.stream.Streams;

public interface IClosableIterator<T, E extends Exception>
extends ICloseable<E>,
Iterable<T> {
    public static <T, E extends Exception> IClosableIterator<T, E> empty() {
        return new IClosableIterator<T, E>(){

            @Override
            public void close() throws Exception {
            }

            @Override
            public T next() throws Exception {
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasNext() throws Exception {
                return false;
            }
        };
    }

    public static <T> IClosableIterator<T, RuntimeException> of(Iterator<T> iterator) {
        return IClosableIterator.of(RuntimeException.class, iterator);
    }

    public static <T, E extends Exception> IClosableIterator<T, E> of(Class<E> exceptionClazz, final Iterator<T> iterator) {
        return new IClosableIterator<T, E>(){

            @Override
            public boolean hasNext() throws Exception {
                return iterator.hasNext();
            }

            @Override
            public T next() throws Exception {
                return iterator.next();
            }

            @Override
            public void close() throws Exception {
            }
        };
    }

    public boolean hasNext() throws E;

    public T next() throws E;

    @Override
    default public Iterator<T> iterator() {
        final IClosableIterator iterator = this;
        return new Iterator<T>(){
            Exception exception;

            @Override
            public boolean hasNext() {
                try {
                    return iterator.hasNext();
                }
                catch (Exception hasNextException) {
                    this.exception = hasNextException;
                    return false;
                }
            }

            @Override
            public T next() throws NoSuchElementException {
                if (this.exception != null) {
                    NoSuchElementException noSuchElementException = new NoSuchElementException();
                    noSuchElementException.addSuppressed(this.exception);
                    throw noSuchElementException;
                }
                try {
                    return iterator.next();
                }
                catch (Exception exception1) {
                    NoSuchElementException noSuchElementException = new NoSuchElementException();
                    noSuchElementException.addSuppressed(this.exception);
                    throw noSuchElementException;
                }
            }
        };
    }

    default public IStream<T, E> stream(Class<E> clazz) {
        return Streams.of(clazz, this);
    }
}

